/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.seda.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.trpr.platform.core.spi.persistence.PersistenceManager;
import org.trpr.platform.core.spi.persistence.PersistentEntity;
import org.trpr.platform.seda.api.checkpointing.StageExecutionEvaluator;
import org.trpr.platform.service.model.common.platformservicerequest.PlatformServiceRequest;
import org.trpr.platform.service.model.common.platformserviceresponse.PlatformServiceResponse;
import org.trpr.platform.servicefw.ServiceContext;
import org.trpr.platform.servicefw.spi.ServiceRequest;
import org.trpr.platform.servicefw.spi.ServiceResponse;

public class SedaStageCheckpointingInterceptor<T, S, P extends PlatformServiceRequest, R extends PlatformServiceResponse>
implements MethodInterceptor {
    private StageExecutionEvaluator<T, S> stageExecutionEvaluator;
    private ServiceContext<T, S, P, R> serviceContext;
    private PersistenceManager persistenceManager;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments;
        PersistentEntity[] entities;
        Object returnValue = null;
        returnValue = invocation.proceed();
        if (this.serviceContext.doesContainerSupportCheckpointing() && null != (entities = this.stageExecutionEvaluator.evaluateStageExecutionResponse((ServiceRequest)(arguments = invocation.getArguments())[0], (ServiceResponse)returnValue))) {
            this.persistenceManager.makePersistent(entities);
        }
        return returnValue;
    }

    public StageExecutionEvaluator<T, S> getStageExecutionEvaluator() {
        return this.stageExecutionEvaluator;
    }

    public void setStageExecutionEvaluator(StageExecutionEvaluator<T, S> stageExecutionEvaluator) {
        this.stageExecutionEvaluator = stageExecutionEvaluator;
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public ServiceContext<T, S, P, R> getServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(ServiceContext<T, S, P, R> serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setPersistenceManager(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }
}

