/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.bootstrapext;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.runtime.spi.bootstrapext.BootstrapExtension;
import org.trpr.platform.runtime.spi.config.ConfigurationException;

public abstract class AbstractBootstrapExtension
implements BootstrapExtension {
    private String name;
    private List<BootstrapExtension> dependencyBEList = new LinkedList<BootstrapExtension>();
    private Map<String, String> properties = new HashMap<String, String>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void addDependency(BootstrapExtension ... extensions) {
        for (BootstrapExtension be : extensions) {
            this.dependencyBEList.add(be);
        }
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    protected String getBootstrapExtensionProperty(String propertyName) throws ConfigurationException {
        if (this.properties.containsKey(propertyName)) {
            return this.properties.get(propertyName);
        }
        throw new ConfigurationException("Requested property found/configured for BootstrapExtension : " + this.getName() + ". Property name is : " + propertyName);
    }

    protected Map<String, String> getAllProperties() {
        return this.properties;
    }

    protected BootstrapExtension getDependencyBootstrapExtension(String beName) throws PlatformException {
        for (BootstrapExtension be : this.dependencyBEList) {
            if (!be.getName().equalsIgnoreCase(beName)) continue;
            return be;
        }
        throw new PlatformException("Dependency BootstrapExtension not found/not loaded. Check configuration and stratup log. Failed to load dependency is : " + beName);
    }
}

