/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.bootstrap.spring;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Calendar;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.spi.management.jmx.AppInstanceAwareMBean;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrap.management.jmx.BootstrapModelMBeanExporter;
import org.trpr.platform.runtime.spi.bootstrap.BootstrapInfo;
import org.trpr.platform.runtime.spi.bootstrap.management.jmx.BootstrapManagedBean;
import org.trpr.platform.runtime.spi.component.ComponentContainer;
import org.trpr.platform.runtime.spi.container.Container;

public class Bootstrap
extends AppInstanceAwareMBean
implements BootstrapManagedBean,
Runnable {
    private static final int EXIT = 0;
    private static final int WAIT = 1;
    private static final MessageFormat STARTUP_DISPLAY = new MessageFormat("\n*************************************************************************\n Trooper __\n      __/  \\         Runtime Nature : {0}\n   __/  \\__/         Component Container(s) : {1}\n  /  \\__/  \\         Startup Time : {2} ms\n  \\__/  \\__/         Host Name: {3}\n     \\__/\n*************************************************************************");
    private static final String FILE_PREFIX = "file:";
    private static final Logger LOGGER = LogFactory.getLogger(Bootstrap.class);
    private static final long SLEEP_BEFORE_EXIT = 2000L;
    private int backgroundThreadState = 1;
    private String bootstrapConfigFile;
    private static RuntimeVariables runtimeVariables;
    private AbstractApplicationContext containerContext;
    private Container container;
    private ClassLoader tccl;
    private String hostName;

    public Bootstrap() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void init() {
        String configPath = System.getProperty("PLATFORM_CONFIG");
        if (configPath == null) {
            System.out.println("Bootstrap config file not found. Trooper runtime exit.");
            return;
        }
        this.init(configPath);
    }

    public void init(String bootstrapConfigFile) {
        this.bootstrapConfigFile = bootstrapConfigFile;
        this.tccl = Thread.currentThread().getContextClassLoader();
        try {
            this.start();
            new BootstrapModelMBeanExporter().exportBootstrapMBean(this);
            Thread backgroundThread = new Thread(this);
            backgroundThread.setName("Trpr-Bgrnd-Thread");
            backgroundThread.start();
        }
        catch (Exception e) {
            LOGGER.error("Fatal error in bootstrap sequence. Cannot continue!", (Throwable)e);
            System.out.println("Fatal error in bootstrap sequence. Cannot continue!");
            e.printStackTrace(System.out);
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public String getBootstrapConfigPath() {
        return this.bootstrapConfigFile;
    }

    @Override
    public void setBootstrapConfigPath(String bootstrapConfigPath) {
        this.bootstrapConfigFile = bootstrapConfigPath;
    }

    @Override
    public void start() throws Exception {
        long start = System.currentTimeMillis();
        System.out.println("** Trooper runtime Bootstrap start **");
        if (Thread.currentThread().getContextClassLoader() != this.tccl) {
            Thread.currentThread().setContextClassLoader(this.tccl);
        }
        runtimeVariables = RuntimeVariables.getInstance();
        File bootstrapFile = new File(this.bootstrapConfigFile);
        this.containerContext = new FileSystemXmlApplicationContext(FILE_PREFIX + bootstrapFile.getAbsolutePath());
        BootstrapInfo bootstrapInfo = (BootstrapInfo)this.containerContext.getBean(BootstrapInfo.class);
        String path = bootstrapInfo.getProjectsRoot();
        if (path.startsWith("$RUNTIME_CONFIG_PATH")) {
            path = path.replace("$RUNTIME_CONFIG_PATH", new File(this.bootstrapConfigFile).getParent());
            bootstrapInfo.setProjectsRoot(new File(path).getCanonicalPath());
        }
        this.container = bootstrapInfo.getContainer();
        this.setPlatformVariablesFromConfig(bootstrapInfo);
        try {
            System.setProperty("org.trpr.application.name", RuntimeVariables.getVariable("org.trpr.application.name"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.container.init();
        this.publishBootstrapEvent("** Trooper bootstrap complete **", "started");
        String ccDisplay = this.container.getComponentContainers().size() > 0 ? "" : "None";
        for (ComponentContainer componentContainer : this.container.getComponentContainers()) {
            ccDisplay = ccDisplay + "[" + componentContainer.getClass().getName() + "] ";
        }
        Object[] displayArgs = new Object[]{RuntimeVariables.getRuntimeNature(), ccDisplay, System.currentTimeMillis() - start, this.hostName};
        LOGGER.info(STARTUP_DISPLAY.format(displayArgs));
        LOGGER.info("** Trooper Bootstrap complete **");
    }

    @Override
    public void stop() throws Exception {
        System.out.println("** Trooper runtime Stopping....**");
        if (this.container != null) {
            this.publishBootstrapEvent("** Stopping Trooper runtime **", "stopped");
            runtimeVariables.clear();
            this.container.destroy();
            this.container = null;
        }
        if (this.containerContext != null) {
            this.containerContext.destroy();
            this.containerContext = null;
        }
        System.out.println("** Trooper runtime stopped! **");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        if (this.backgroundThreadState == 0) {
            return;
        }
        System.out.println("** Trooper runtime shutdown initiated....**");
        this.stop();
        this.backgroundThreadState = 0;
        Bootstrap bootstrap = this;
        synchronized (bootstrap) {
            this.notifyAll();
        }
        Thread.currentThread();
        Thread.sleep(2000L);
        System.out.println("** Trooper runtime shutdown! **");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            switch (this.backgroundThreadState) {
                case 1: {
                    Bootstrap bootstrap = this;
                    synchronized (bootstrap) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        break;
                    }
                }
                case 0: {
                    return;
                }
            }
        }
    }

    private void setPlatformVariablesFromConfig(BootstrapInfo bootstrapInfo) {
        runtimeVariables.setVariable("org.trpr.application.name", bootstrapInfo.getApplicationName());
        runtimeVariables.setVariable("org.trpr.platform.runtime.projects.root", bootstrapInfo.getProjectsRoot());
        runtimeVariables.setVariable("org.trpr.platform.runtime.nature", bootstrapInfo.getRuntimeNature());
    }

    private void publishBootstrapEvent(String msg, String status) {
        PlatformEvent bootstrapEvent = new PlatformEvent();
        bootstrapEvent.setEventMessage(msg);
        bootstrapEvent.setEventStatus(status);
        bootstrapEvent.setCreatedDate(Calendar.getInstance());
        bootstrapEvent.setEventSource(this.getClass().getName());
        bootstrapEvent.setEventType("BootstrapMonitoredEvent");
        bootstrapEvent.setHostName(this.hostName);
        this.container.publishBootstrapEvent(bootstrapEvent);
    }
}

