/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.config.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class PropertyPlaceholderConfigurer
extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer {
    private static final Logger LOGGER = LogFactory.getLogger(PropertyPlaceholderConfigurer.class);
    private String defaultPropertiesOnClasspath;
    private String propertiesOnConfigPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties mergeProperties() throws IOException {
        String runtimePropertiesPath;
        Properties mergedProperties = new Properties();
        if (this.getDefaultPropertiesOnClasspath() != null) {
            mergedProperties.load(new ClassPathResource(this.getDefaultPropertiesOnClasspath()).getInputStream());
            super.setProperties(mergedProperties);
        }
        mergedProperties = super.mergeProperties();
        if (this.getPropertiesOnConfigPath() != null) {
            InputStreamReader fileReader = null;
            try {
                fileReader = new FileReader(FileLocator.findUniqueFile(this.getPropertiesOnConfigPath()));
                mergedProperties.load(fileReader);
            }
            catch (Exception e) {
                LOGGER.warn("Error loading property configurations from file : {}. Using defaults", (Object)this.getPropertiesOnConfigPath());
            }
            finally {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
        }
        if ((runtimePropertiesPath = RuntimeVariables.getVariable("PLATFORM_PROPERTIES")) != null) {
            try {
                mergedProperties.load(new FileInputStream(new File(runtimePropertiesPath)));
            }
            catch (Exception e) {
                LOGGER.warn("Error loading property configurations from file specified in JVM starup : {}. Using defaults", (Object)runtimePropertiesPath);
            }
        }
        return mergedProperties;
    }

    public String getDefaultPropertiesOnClasspath() {
        return this.defaultPropertiesOnClasspath;
    }

    public void setDefaultPropertiesOnClasspath(String defaultPropertiesOnClasspath) {
        this.defaultPropertiesOnClasspath = defaultPropertiesOnClasspath;
    }

    public String getPropertiesOnConfigPath() {
        return this.propertiesOnConfigPath;
    }

    public void setPropertiesOnConfigPath(String propertiesOnConfigPath) {
        this.propertiesOnConfigPath = propertiesOnConfigPath;
    }
}

