/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.bootstrap.spring;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Calendar;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.spi.management.jmx.AppInstanceAwareMBean;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrap.management.jmx.BootstrapModelMBeanExporter;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.bootstrap.BootstrapInfo;
import org.trpr.platform.runtime.spi.bootstrap.management.jmx.BootstrapManagedBean;
import org.trpr.platform.runtime.spi.container.Container;

public class Bootstrap
extends AppInstanceAwareMBean
implements BootstrapManagedBean,
Runnable {
    private static final int WAIT = 0;
    private static final int EXIT = 1;
    private static final MessageFormat STARTUP_DISPLAY = new MessageFormat("\n*************************************************************************\n Trooper __\n      __/  \\         Runtime Nature : {0}\n   __/  \\__/         Component Container : {1}\n  /  \\__/  \\         Startup Time : {2} ms\n  \\__/  \\__/         Host Name: {3}\n     \\__/\n*************************************************************************");
    private static final String FILE_PREFIX = "file:";
    private static final Logger LOGGER = LogFactory.getLogger(Bootstrap.class);
    private int backgroundThreadState = 0;
    private String bootstrapConfigFile;
    private static RuntimeVariables runtimeVariables;
    private AbstractApplicationContext containerContext;
    private Container container;
    private ClassLoader tccl;
    private String hostName;

    public Bootstrap() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void init() {
        String configPath = System.getProperty("PLATFORM_CONFIG");
        if (configPath == null) {
            System.out.println("Bootstrap config file not found. Trooper runtime exit.");
            return;
        }
        this.init(configPath);
    }

    public void init(String bootstrapConfigFile) {
        this.bootstrapConfigFile = bootstrapConfigFile;
        this.tccl = Thread.currentThread().getContextClassLoader();
        try {
            this.start();
            new BootstrapModelMBeanExporter().exportBootstrapMBean(this);
        }
        catch (Exception e) {
            LOGGER.error("Fatal error in bootstrap sequence. Cannot continue!", (Throwable)e);
            System.out.println("Fatal error in bootstrap sequence. Cannot continue!");
            e.printStackTrace(System.out);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new BootstrapShutdownThread(this));
        Thread backgroundThread = new Thread(this);
        backgroundThread.setName("Trpr-Bgrnd-Thread");
        backgroundThread.start();
    }

    public void configureLogging() {
        File[] loggingConfigFiles = FileLocator.findFiles("logback.xml", new File(this.bootstrapConfigFile).getParent());
        if (loggingConfigFiles.length == 0) {
            System.out.println("Logging configuration file : logback.xml not found!. Unable to initialize logging framework");
            return;
        }
        if (loggingConfigFiles.length > 1) {
            for (File loggingFile : loggingConfigFiles) {
                if (!loggingFile.getParent().equals(new File(this.getBootstrapConfigPath()).getParent())) continue;
                System.out.println("Multiple ( Total: " + loggingConfigFiles.length + " ) logging config files found. Using the occurence co-located with bootstrap config file.");
                this.configureLoggingFromFile(loggingFile);
                return;
            }
        }
        System.out.println("Using logging config file : " + loggingConfigFiles[0].getAbsolutePath());
        this.configureLoggingFromFile(loggingConfigFiles[0]);
    }

    @Override
    public String getBootstrapConfigPath() {
        return this.bootstrapConfigFile;
    }

    @Override
    public void reloadLoggingConfigurations() {
        this.configureLogging();
    }

    @Override
    public void setBootstrapConfigPath(String bootstrapConfigPath) {
        this.bootstrapConfigFile = bootstrapConfigPath;
    }

    @Override
    public void start() throws Exception {
        long start = System.currentTimeMillis();
        System.out.println("** Trooper runtime Bootstrap start **");
        if (Thread.currentThread().getContextClassLoader() != this.tccl) {
            Thread.currentThread().setContextClassLoader(this.tccl);
        }
        runtimeVariables = RuntimeVariables.getInstance();
        try {
            this.configureLogging();
            File bootstrapFile = new File(this.bootstrapConfigFile);
            this.containerContext = new FileSystemXmlApplicationContext(FILE_PREFIX + bootstrapFile.getAbsolutePath());
            BootstrapInfo bootstrapInfo = (BootstrapInfo)this.containerContext.getBean(BootstrapInfo.class);
            String path = bootstrapInfo.getProjectsRoot();
            if (path.startsWith("$RUNTIME_CONFIG_PATH")) {
                path = path.replace("$RUNTIME_CONFIG_PATH", new File(this.bootstrapConfigFile).getParent());
                bootstrapInfo.setProjectsRoot(new File(path).getCanonicalPath());
            }
            this.container = bootstrapInfo.getContainer();
            this.setPlatformVariablesFromConfig(bootstrapInfo);
            try {
                System.setProperty("org.trpr.application.name", RuntimeVariables.getVariable("org.trpr.application.name"));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.container.init();
        }
        catch (Exception e) {
            LOGGER.error("Fatal error in bootstrap sequence. Cannot continue!", (Throwable)e);
            System.out.println("Fatal error in bootstrap sequence. Cannot continue!");
            e.printStackTrace(System.out);
            return;
        }
        this.publishBootstrapEvent("** Trooper bootstrap complete **", "started");
        String ccDisplay = RuntimeVariables.getContainerType() == null ? "None" : RuntimeVariables.getContainerType();
        Object[] displayArgs = new Object[]{RuntimeVariables.getRuntimeNature(), ccDisplay, System.currentTimeMillis() - start, this.hostName};
        LOGGER.info(STARTUP_DISPLAY.format(displayArgs));
        LOGGER.info("** Trooper Bootstrap complete **");
    }

    @Override
    public void stop() throws Exception {
        System.out.println("** Trooper runtime Stopping....**");
        if (this.container != null) {
            this.publishBootstrapEvent("** Stopping Trooper runtime **", "stopped");
            runtimeVariables.clear();
            this.container.destroy();
            this.container = null;
        }
        if (this.containerContext != null) {
            this.containerContext.destroy();
            this.containerContext = null;
        }
        System.out.println("** Trooper runtime stopped! **");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        if (this.backgroundThreadState == 1) {
            return;
        }
        System.out.println("** Trooper runtime shutdown initiated....**");
        this.stop();
        this.backgroundThreadState = 1;
        Bootstrap bootstrap = this;
        synchronized (bootstrap) {
            this.notifyAll();
        }
        System.out.println("** Trooper runtime shutdown! **");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            switch (this.backgroundThreadState) {
                case 0: {
                    Bootstrap bootstrap = this;
                    synchronized (bootstrap) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        break;
                    }
                }
                case 1: {
                    return;
                }
            }
        }
    }

    private void configureLoggingFromFile(File loggingConfigFile) {
        try {
            LogFactory.configureLogging((File)loggingConfigFile);
        }
        catch (Exception e) {
            System.err.println("Error initializing logging framework!. Error message : " + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }
        LOGGER.info("Logging framework is now initialized!");
    }

    private void setPlatformVariablesFromConfig(BootstrapInfo bootstrapInfo) {
        runtimeVariables.setVariable("org.trpr.application.name", bootstrapInfo.getApplicationName());
        runtimeVariables.setVariable("org.trpr.platform.runtime.projects.root", bootstrapInfo.getProjectsRoot());
        runtimeVariables.setVariable("org.trpr.platform.runtime.nature", bootstrapInfo.getRuntimeNature());
        if (bootstrapInfo.getComponentContainerClassName() != null) {
            runtimeVariables.setVariable("org.trpr.platform.runtime.componentContainer", bootstrapInfo.getComponentContainerClassName());
        }
    }

    private void publishBootstrapEvent(String msg, String status) {
        PlatformEvent bootstrapEvent = new PlatformEvent();
        bootstrapEvent.setEventMessage(msg);
        bootstrapEvent.setEventStatus(status);
        bootstrapEvent.setCreatedDate(Calendar.getInstance());
        bootstrapEvent.setEventSource(this.getClass().getName());
        bootstrapEvent.setEventType("BootstrapMonitoredEvent");
        bootstrapEvent.setHostName(this.hostName);
        this.container.publishBootstrapEvent(bootstrapEvent);
    }

    private class BootstrapShutdownThread
    extends Thread {
        private Bootstrap bootstrap;

        public BootstrapShutdownThread(Bootstrap bootstrap2) {
            this.bootstrap = bootstrap2;
        }

        @Override
        public void run() {
            try {
                this.bootstrap.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

