/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.bootstrap.management.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.trpr.platform.runtime.spi.bootstrap.management.jmx.BootstrapManagedBean;

public class BootstrapModelMBeanExporter {
    private static final String MBEAN_NAME = "spring.application:type=Trooper,application=Runtime,name=Bootstrap-";
    private static final String VOID = "void";
    private static final String STRING = "java.lang.String";
    private static final String OBJECT_REFERENCE = "ObjectReference";
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public void exportBootstrapMBean(BootstrapManagedBean bootstrap) throws Exception {
        ModelMBeanInfoSupport mmbInfoSupport = new ModelMBeanInfoSupport(bootstrap.getClass().getName(), "Trooper Runtime startup class", null, null, this.buildModelMBeanOperationInfo(), null);
        RequiredModelMBean rmb = new RequiredModelMBean(mmbInfoSupport);
        rmb.setManagedResource(bootstrap, OBJECT_REFERENCE);
        ObjectName objectName = new ObjectName(bootstrap.getMBeanNameSuffix(bootstrap, MBEAN_NAME) != null ? MBEAN_NAME + bootstrap.getMBeanNameSuffix(bootstrap, MBEAN_NAME) : MBEAN_NAME);
        if (this.mbeanServer.isRegistered(objectName)) {
            this.mbeanServer.unregisterMBean(objectName);
        }
        this.mbeanServer.registerMBean(rmb, objectName);
    }

    private ModelMBeanOperationInfo[] buildModelMBeanOperationInfo() {
        ModelMBeanOperationInfo startOperationInfo = new ModelMBeanOperationInfo("start", "Start Runtime", null, VOID, 1);
        ModelMBeanOperationInfo stopOperationInfo = new ModelMBeanOperationInfo("stop", "Stop Runtime", null, VOID, 1);
        ModelMBeanOperationInfo destroyOperationInfo = new ModelMBeanOperationInfo("destroy", "Shutdown Runtime", null, VOID, 1);
        ModelMBeanOperationInfo reloadLoggingConfigurationsOperationInfo = new ModelMBeanOperationInfo("reloadLoggingConfigurations", "Reload Logging configuration", null, VOID, 1);
        ModelMBeanOperationInfo getBootstrapConfigPathOperationInfo = new ModelMBeanOperationInfo("getBootstrapConfigPath", "Gets the bootstrap config path", null, STRING, 1);
        ModelMBeanOperationInfo setBootstrapConfigPathOperationInfo = new ModelMBeanOperationInfo("setBootstrapConfigPath", "Sets the bootstrap config path", new MBeanParameterInfo[]{new MBeanParameterInfo("bootstrapConfigPath", STRING, "The bootstrap config path")}, VOID, 1);
        return new ModelMBeanOperationInfo[]{startOperationInfo, stopOperationInfo, destroyOperationInfo, reloadLoggingConfigurationsOperationInfo, getBootstrapConfigPathOperationInfo, setBootstrapConfigPathOperationInfo};
    }
}

