/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.impl.validation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.springframework.beans.PropertyAccessException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.spi.execution.ResultCode;
import org.trpr.platform.spi.execution.Severity;
import org.trpr.platform.spi.validation.ValidationResult;
import org.trpr.platform.spi.validation.Validator;

public class ExpressionBasedValidator
implements Validator {
    private static final String NPE_MESSAGE = "Unexpected null error encountered during validation";
    private static final Logger LOGGER = LogFactory.getLogger(ExpressionBasedValidator.class);
    private static Map<String, Serializable> compiledExpressionsCache = new HashMap<String, Serializable>();
    private String label;
    private String messageId;
    private String defaultMessage;
    private static final ParserContext CTX = new ParserContext();

    public ExpressionBasedValidator() {
    }

    public ExpressionBasedValidator(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public ExpressionBasedValidator(String messageId, String defaultMessage) {
        this.messageId = messageId;
        this.defaultMessage = defaultMessage;
    }

    public ExpressionBasedValidator(String messageId, String defaultMessage, String label) {
        this.messageId = messageId;
        this.defaultMessage = defaultMessage;
        this.label = label;
    }

    @Override
    public ValidationResult[] validate(String mvelExpression, ResultCode resultCode, Object inputObject) {
        boolean mvelResult = false;
        try {
            Serializable compiled = compiledExpressionsCache.get(mvelExpression);
            if (compiled == null) {
                compiled = MVEL.compileExpression((String)mvelExpression, (ParserContext)CTX);
                compiledExpressionsCache.put(mvelExpression, compiled);
            }
            mvelResult = (Boolean)MVEL.executeExpression((Object)compiled, (Object)inputObject);
        }
        catch (PropertyAccessException pae) {
            if (pae.getCause() instanceof NullPointerException) {
                LOGGER.warn("Null pointer exception occurred in property access during expression evaluation in validator", pae.getCause());
                return new ValidationResult[]{new ValidationResult(Severity.FATAL, resultCode, NPE_MESSAGE, this.label)};
            }
            throw pae;
        }
        if (!mvelResult) {
            String message = this.defaultMessage;
            return new ValidationResult[]{new ValidationResult(resultCode, message)};
        }
        return null;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    static {
        CTX.addPackageImport("java.util");
        CTX.addPackageImport("org.trpr");
    }
}

