/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.json;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.codehaus.jackson.map.ObjectMapper;
import org.trpr.platform.integration.spi.json.JSONTranscoder;
import org.trpr.platform.integration.spi.marshalling.MarshallingException;

public class JSONTranscoderImpl
implements JSONTranscoder {
    private ObjectMapper mapper = new ObjectMapper();
    private DateFormat dateFormat = new SimpleDateFormat();

    public JSONTranscoderImpl() {
        this.mapper.setDateFormat(this.getDateFormat());
    }

    @Override
    public String marshal(Object object) throws MarshallingException {
        try {
            return this.mapper.writer().withDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new MarshallingException("Error marshalling object : " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T unmarshal(String json, Class<T> clazz) throws MarshallingException {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new MarshallingException("Error unmarshalling object : " + e.getMessage(), e);
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }
}

