/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.NewBeanInstanceStrategy;
import org.trpr.platform.integration.spi.json.JSONTranscoder;
import org.trpr.platform.integration.spi.marshalling.MarshallingException;

public class JSONTranscoderImpl
implements JSONTranscoder {
    private static final int PRETTY_PRINT_INDENT = 4;
    private static Map<String, String> instantiationMap = new HashMap<String, String>();

    @Override
    public String marshal(Object object) throws MarshallingException {
        return JSONSerializer.toJSON((Object)object).toString(4);
    }

    @Override
    public <T> T unmarshal(String json, Class<T> clazz) throws MarshallingException {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(clazz);
        jsonConfig.setNewBeanInstanceStrategy((NewBeanInstanceStrategy)new CustomNewInstanceStrategy());
        return (T)JSONSerializer.toJava((JSON)JSONObject.fromObject((Object)json), (JsonConfig)jsonConfig);
    }

    public void setInstantiationMap(Map<String, String> map) {
        instantiationMap = map;
    }

    static {
        instantiationMap.put("java.util.Calendar", "getInstance");
        instantiationMap.put("java.util.TimeZone", "getDefault");
    }

    private class CustomNewInstanceStrategy
    extends NewBeanInstanceStrategy {
        private Object[] EMPTY_ARGS = new Object[0];
        private Class[] EMPTY_PARAM_TYPES = new Class[0];

        private CustomNewInstanceStrategy() {
        }

        public Object newInstance(Class target, JSONObject source) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, InvocationTargetException {
            if (target != null) {
                if (instantiationMap.containsKey(target.getName())) {
                    return target.getDeclaredMethod((String)instantiationMap.get(target.getName()), null).invoke(null, (Object[])null);
                }
                Constructor c = target.getDeclaredConstructor(this.EMPTY_PARAM_TYPES);
                c.setAccessible(true);
                return c.newInstance(this.EMPTY_ARGS);
            }
            return null;
        }
    }
}

