/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.messaging.event;

import org.springframework.beans.factory.DisposableBean;
import org.trpr.platform.core.impl.event.AbstractEndpointEventConsumerImpl;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.impl.management.jmx.JMXNotificationDispatcher;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.integration.impl.messaging.RabbitMQMessagePublisherImpl;
import org.trpr.platform.integration.spi.messaging.MessagingException;
import org.trpr.platform.model.event.PlatformEvent;

public class RabbitMQEventEndpointDispatcher
extends AbstractEndpointEventConsumerImpl
implements DisposableBean {
    private static final Logger LOGGER = LogFactory.getLogger(RabbitMQEventEndpointDispatcher.class);
    private RabbitMQMessagePublisherImpl rabbitMessagePublisher;
    private JMXNotificationDispatcher jmxNotificationDispatcher;

    public void destroy() throws Exception {
        try {
            this.rabbitMessagePublisher.closeConnections();
        }
        catch (MessagingException e) {
            LOGGER.info("Error closing connections held by RabbitMQMessagePublisherImpl.Ignoring it as this Event consumer is closing anyway. Error is : " + e.getMessage());
        }
    }

    protected void handlePlatformEvent(PlatformEvent platformEvent) {
        try {
            this.rabbitMessagePublisher.publish(platformEvent);
        }
        catch (MessagingException e) {
            LOGGER.error("Error publishing Platform Event to handling queues. Event is of type : " + platformEvent.getEventType() + " . Source is : " + platformEvent.getEventSource(), (Throwable)e);
            this.jmxNotificationDispatcher.dispatchException((Throwable)e, ((Object)((Object)this)).getClass().getName());
        }
    }

    public RabbitMQMessagePublisherImpl getRabbitMessagePublisher() {
        return this.rabbitMessagePublisher;
    }

    public void setRabbitMessagePublisher(RabbitMQMessagePublisherImpl rabbitMessagePublisher) {
        this.rabbitMessagePublisher = rabbitMessagePublisher;
    }

    public JMXNotificationDispatcher getJmxNotificationDispatcher() {
        return this.jmxNotificationDispatcher;
    }

    public void setJmxNotificationDispatcher(JMXNotificationDispatcher jmxNotificationDispatcher) {
        this.jmxNotificationDispatcher = jmxNotificationDispatcher;
    }
}

