/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.messaging;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.util.PlatformUtils;
import org.trpr.platform.integration.impl.messaging.RabbitConnectionHolder;
import org.trpr.platform.integration.impl.messaging.RabbitMQConfiguration;
import org.trpr.platform.integration.spi.messaging.MessagePublisher;
import org.trpr.platform.integration.spi.messaging.MessagingException;

public class RabbitMQMessagePublisherImpl
implements MessagePublisher,
DisposableBean {
    private static final String ENCODING = "UTF-8";
    private static final Logger LOGGER = LogFactory.getLogger(RabbitMQMessagePublisherImpl.class);
    private List<RabbitMQConfiguration> rabbitMQConfigurations;
    private RabbitConnectionHolder[] rabbitConnectionHolders;
    private long totNoOfMessagesQueued;

    public void initialize() {
    }

    public List<RabbitMQConfiguration> getRabbitMQConfigurations() {
        return this.rabbitMQConfigurations;
    }

    public void setRabbitMQConfigurations(List<RabbitMQConfiguration> rabbitMQConfigurations) {
        this.rabbitMQConfigurations = rabbitMQConfigurations;
        this.rabbitConnectionHolders = new RabbitConnectionHolder[rabbitMQConfigurations.size()];
    }

    public void publishString(String string) throws MessagingException {
        this.publish(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void publish(Object message) throws MessagingException {
        if (message == null) {
            throw new MessagingException("Message parameter cannot be null");
        }
        noOfQueues = this.rabbitMQConfigurations.size();
        attempt = 0;
        lastUsedConfiguration = null;
        while (attempt < noOfQueues) {
            connectionIndex = (int)(this.totNoOfMessagesQueued % (long)noOfQueues);
            rabbitMQConfiguration = lastUsedConfiguration = this.rabbitMQConfigurations.get(connectionIndex);
            if (this.rabbitConnectionHolders[connectionIndex] == null || !this.rabbitConnectionHolders[connectionIndex].isValid()) {
                try {
                    var7_7 = rabbitMQConfiguration;
                    // MONITORENTER : var7_7
                    if (this.rabbitConnectionHolders[connectionIndex] == null) {
                        this.rabbitConnectionHolders[connectionIndex] = new RabbitConnectionHolder(rabbitMQConfiguration);
                        this.rabbitConnectionHolders[connectionIndex].createConnection();
                    }
                    // MONITOREXIT : var7_7
                }
                catch (Exception e) {
                    RabbitMQMessagePublisherImpl.LOGGER.error("Error while initializing Rabbit connection. Will try others. Error is : " + e.getMessage(), (Throwable)e);
                    ++attempt;
                    ++this.totNoOfMessagesQueued;
                    continue;
                }
            }
            try {
                block20: {
                    block19: {
                        isMessageOfTypeString = message instanceof String;
                        v1 = body = isMessageOfTypeString != false ? ((String)message).getBytes("UTF-8") : PlatformUtils.toBytes((Object)message);
                        v2 = rabbitMQConfiguration.isDurable() ? (isMessageOfTypeString ? MessageProperties.PERSISTENT_TEXT_PLAIN : MessageProperties.PERSISTENT_BASIC) : (msgProps = isMessageOfTypeString != false ? MessageProperties.TEXT_PLAIN : MessageProperties.BASIC);
                        if (!rabbitMQConfiguration.isDurable()) ** GOTO lbl52
                        var10_14 = this.rabbitConnectionHolders[connectionIndex].getChannel();
                        // MONITORENTER : var10_14
                        this.rabbitConnectionHolders[connectionIndex].getChannel().basicPublish(rabbitMQConfiguration.getExchangeName(), rabbitMQConfiguration.getRoutingKey(), msgProps, body);
                        if ((this.totNoOfMessagesQueued + 1L) % (long)rabbitMQConfiguration.getDurableMessageCommitCount() != 0L) ** GOTO lbl50
                        if (!rabbitMQConfiguration.isDisableTX()) break block19;
                        RabbitMQMessagePublisherImpl.LOGGER.error("Configuration conflict. TX disabled for message publishing on durable queue. Message will not be published.");
                        // MONITOREXIT : var10_14
                        {
                            catch (Throwable v3) {
                                // MONITOREXIT : var10_14
                                throw v3;
                            }
                        }
                    }
                    this.rabbitConnectionHolders[connectionIndex].getChannel().txCommit();
lbl50:
                    // 2 sources

                    // MONITOREXIT : var10_14
                    break block20;
lbl52:
                    // 1 sources

                    this.rabbitConnectionHolders[connectionIndex].getChannel().basicPublish(rabbitMQConfiguration.getExchangeName(), rabbitMQConfiguration.getRoutingKey(), msgProps, body);
                }
                ++attempt;
                ++this.totNoOfMessagesQueued;
                return;
            }
            catch (Exception e) {
                this.rabbitConnectionHolders[connectionIndex] = null;
                RabbitMQMessagePublisherImpl.LOGGER.error("Error while publishing message into queue. Will try other configurations. Error is : " + e.getMessage(), (Throwable)e);
                ++attempt;
                ++this.totNoOfMessagesQueued;
            }
            catch (Throwable var11_15) {
                ++attempt;
                ++this.totNoOfMessagesQueued;
                throw var11_15;
            }
        }
        throw new MessagingException("Error while publishing message into queue. All configurations failed!. Last failed configuration : " + lastUsedConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnections() throws MessagingException {
        int i = 0;
        while (i < this.rabbitConnectionHolders.length) {
            if (this.rabbitConnectionHolders[i] != null && this.rabbitConnectionHolders[i].isValid()) {
                if (this.rabbitMQConfigurations.get(i).isDurable() && !this.rabbitMQConfigurations.get(i).isDisableTX()) {
                    try {
                        Channel channel = this.rabbitConnectionHolders[i].getChannel();
                        synchronized (channel) {
                            this.rabbitConnectionHolders[i].getChannel().txCommit();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Error committing remaining durable messages. Messages will be lost. Continuing to close connection for this configuration : " + this.rabbitMQConfigurations.get(i));
                    }
                }
                this.rabbitConnectionHolders[i].closeConnection();
                this.rabbitConnectionHolders[i] = null;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueDepth() throws MessagingException {
        int noOfQueues = this.rabbitMQConfigurations.size();
        int attempt = 0;
        RabbitMQConfiguration lastUsedConfiguration = null;
        while (attempt < noOfQueues) {
            int connectionIndex = (int)(this.totNoOfMessagesQueued % (long)noOfQueues);
            RabbitMQConfiguration RabbitMQConfiguration2 = lastUsedConfiguration = this.rabbitMQConfigurations.get(connectionIndex);
            try {
                int count;
                if (this.rabbitConnectionHolders[connectionIndex] == null || !this.rabbitConnectionHolders[connectionIndex].isValid()) {
                    RabbitMQConfiguration rabbitMQConfiguration = RabbitMQConfiguration2;
                    synchronized (rabbitMQConfiguration) {
                        if (this.rabbitConnectionHolders[connectionIndex] == null) {
                            this.rabbitConnectionHolders[connectionIndex] = new RabbitConnectionHolder(RabbitMQConfiguration2);
                            this.rabbitConnectionHolders[connectionIndex].createConnection();
                        }
                    }
                }
                int n = count = this.rabbitConnectionHolders[connectionIndex].getMessageCount();
                return n;
            }
            catch (Exception e) {
                LOGGER.error("Error while initializing Rabbit connection / getting message count. Will try others. Error is : " + e.getMessage(), (Throwable)e);
                this.rabbitConnectionHolders[connectionIndex] = null;
            }
            finally {
                ++attempt;
                ++this.totNoOfMessagesQueued;
            }
        }
        throw new MessagingException("Error while getting queue depth. All configurations failed!. Last failed configuration : " + lastUsedConfiguration);
    }

    public void destroy() throws Exception {
        this.closeConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RabbitConnectionHolder[] getRabbitConnectionHolders() {
        int i = 0;
        while (i < this.rabbitConnectionHolders.length) {
            if (this.rabbitConnectionHolders[i] == null || !this.rabbitConnectionHolders[i].isValid()) {
                try {
                    RabbitMQConfiguration rabbitMQConfiguration = this.rabbitMQConfigurations.get(i);
                    synchronized (rabbitMQConfiguration) {
                        if (this.rabbitConnectionHolders[i] == null) {
                            this.rabbitConnectionHolders[i] = new RabbitConnectionHolder(this.rabbitMQConfigurations.get(i));
                            this.rabbitConnectionHolders[i].createConnection();
                        }
                    }
                }
                catch (MessagingException e) {
                    LOGGER.error("Error initiazlizing Rabbit connection. Connection not available for configuration : " + this.rabbitMQConfigurations.get(i), (Throwable)e);
                }
            }
            ++i;
        }
        return this.rabbitConnectionHolders;
    }
}

