/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.messaging;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.QueueingConsumer;
import java.util.List;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.util.PlatformUtils;
import org.trpr.platform.integration.impl.messaging.RabbitConnectionHolder;
import org.trpr.platform.integration.impl.messaging.RabbitMQRpcConfiguration;
import org.trpr.platform.integration.spi.messaging.MessagingException;
import org.trpr.platform.integration.spi.messaging.MessagingTimeoutException;
import org.trpr.platform.integration.spi.messaging.RpcClient;

public class RabbitMQRPCClientImpl
implements RpcClient {
    private static final String ENCODING = "UTF-8";
    private static final Logger LOGGER = LogFactory.getLogger(RabbitMQRPCClientImpl.class);
    private List<RabbitMQRpcConfiguration> rabbitMQRpcConfigurations;
    private RabbitConnectionHolder[] rabbitConnectionHolders;
    private long totNoOfMessagesQueued;

    public void initialize() {
    }

    public List<RabbitMQRpcConfiguration> getRabbitMQRpcConfigurations() {
        return this.rabbitMQRpcConfigurations;
    }

    public void setRabbitMQRPCConfiguration(List<RabbitMQRpcConfiguration> rabbitMQRpcConfigurations) {
        this.rabbitMQRpcConfigurations = rabbitMQRpcConfigurations;
        this.rabbitConnectionHolders = new RabbitConnectionHolder[rabbitMQRpcConfigurations.size()];
    }

    public String sendString(String message, int timeout) throws MessagingTimeoutException, MessagingException {
        return (String)this.send(message, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object send(Object message, int timeout) throws MessagingTimeoutException, MessagingException {
        if (null == message) {
            throw new MessagingException("Message parameter cannot be null");
        }
        int noOfQueues = this.rabbitMQRpcConfigurations.size();
        int attempt = 0;
        RabbitMQRpcConfiguration lastUsedConfiguration = null;
        while (attempt < noOfQueues) {
            block15: {
                int connectionIndex = (int)(this.totNoOfMessagesQueued % (long)noOfQueues);
                RabbitMQRpcConfiguration rabbitMQRpcConfiguration = lastUsedConfiguration = this.rabbitMQRpcConfigurations.get(connectionIndex);
                RabbitConnectionHolder connectionHolder = this.rabbitConnectionHolders[connectionIndex];
                if (connectionHolder == null || !connectionHolder.isValid()) {
                    try {
                        RabbitMQRpcConfiguration rabbitMQRpcConfiguration2 = rabbitMQRpcConfiguration;
                        synchronized (rabbitMQRpcConfiguration2) {
                            if (connectionHolder == null || !connectionHolder.isValid()) {
                                connectionHolder = new RabbitConnectionHolder(rabbitMQRpcConfiguration);
                                connectionHolder.createConnection();
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while initializing Rabbit connection. Will try others. Error is : " + e.getMessage(), (Throwable)e);
                        ++attempt;
                        ++this.totNoOfMessagesQueued;
                        continue;
                    }
                }
                boolean isMessageOfTypeString = message instanceof String;
                byte[] body = isMessageOfTypeString ? ((String)message).getBytes(ENCODING) : PlatformUtils.toBytes((Object)message);
                AMQP.BasicProperties msgProps = new AMQP.BasicProperties("text/plain", null, null, Integer.valueOf(1), null, null, connectionHolder.getConsumerQueueName(), null, null, null, null, null, null, null);
                connectionHolder.getChannel().basicPublish(rabbitMQRpcConfiguration.getExchangeName(), rabbitMQRpcConfiguration.getRoutingKey(), msgProps, body);
                QueueingConsumer.Delivery delivery = connectionHolder.getConsumer().nextDelivery((long)timeout);
                if (delivery == null) break block15;
                this.rabbitConnectionHolders[connectionIndex] = connectionHolder;
                Object object = isMessageOfTypeString ? new String(delivery.getBody(), ENCODING) : PlatformUtils.toObject((byte[])delivery.getBody());
                ++attempt;
                ++this.totNoOfMessagesQueued;
                return object;
            }
            try {
                try {
                    throw new MessagingTimeoutException((long)timeout);
                }
                catch (Exception e) {
                    this.rabbitConnectionHolders[connectionIndex] = null;
                    LOGGER.error("Error while publishing message into queue. Will try other configurations. Error is : " + e.getMessage(), (Throwable)e);
                    ++attempt;
                    ++this.totNoOfMessagesQueued;
                }
            }
            catch (Throwable throwable) {
                ++attempt;
                ++this.totNoOfMessagesQueued;
                throw throwable;
            }
        }
        throw new MessagingException("Error while publishing message into queue. All configurations failed!. Last failed configuration : " + lastUsedConfiguration);
    }

    public void closeConnections() throws MessagingException {
        for (int i = 0; i < this.rabbitConnectionHolders.length; ++i) {
            if (this.rabbitConnectionHolders[i] == null || !this.rabbitConnectionHolders[i].isValid()) continue;
            this.rabbitConnectionHolders[i].closeConnection();
            this.rabbitConnectionHolders[i] = null;
        }
    }
}

