/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.seda.echo.mule.transformer;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.example.model.service.echoservice.EchoServiceRequest;
import org.trpr.example.model.service.greetingservice.GreetingServiceRequest;
import org.trpr.example.model.service.greetingservice.GreetingServiceResponse;
import org.trpr.platform.servicefw.impl.ServiceRequestImpl;
import org.trpr.platform.servicefw.impl.ServiceResponseImpl;
import org.trpr.platform.servicefw.spi.ServiceRequest;

public class GreetingSerResToEchoSerReqTransformer<P extends GreetingServiceRequest, T extends GreetingServiceResponse, S extends EchoServiceRequest>
extends AbstractTransformer {
    private static final String SERVICE_NAME = "echoService";
    private static final String SERVICE_VERSION = "1.0";

    public GreetingSerResToEchoSerReqTransformer() {
        this.registerSourceType(byte[].class);
        this.setReturnClass(ServiceRequest.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        EchoServiceRequest echoServiceRequest = new EchoServiceRequest();
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])src));
            ServiceResponseImpl serviceResponse = (ServiceResponseImpl)ois.readObject();
            ois.close();
            GreetingServiceResponse greetingServiceResponse = (GreetingServiceResponse)serviceResponse.getResponseData();
            Earthling earthling = ((GreetingServiceRequest)greetingServiceResponse.getPlatformServiceRequest()).getEarthling();
            echoServiceRequest.setEarthling(earthling);
            echoServiceRequest.setVersion(SERVICE_VERSION);
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return new ServiceRequestImpl((Object)echoServiceRequest, SERVICE_NAME, echoServiceRequest.getVersion());
    }
}

