/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.service.cep;

import com.espertech.esper.client.EPServiceProvider;
import java.util.HashSet;
import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.example.service.cep.CEPEngineResource;
import org.trpr.example.service.cep.CEPTaskData;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.impl.task.AbstractTask;
import org.trpr.platform.spi.task.TaskResult;

public class CEPTask<T>
extends AbstractTask {
    private static final String ITEM_LIST_VAR = "itemsList";
    private static final Logger LOGGER = LogFactory.getLogger(CEPTask.class);
    private static final long serialVersionUID = 1L;
    private static boolean isVarSet;

    public CEPTask(CEPTaskData<Earthling, CEPEngineResource<T>> taskData, String id) {
        super(id);
        this.setTaskData(taskData);
    }

    protected void doExecute() {
        Earthling earthling = (Earthling)this.getTaskData().getEntityByName(Earthling.class.getName())[0];
        try {
            EPServiceProvider epProvider = (EPServiceProvider)((CEPEngineResource)this.getTaskData().getResourceByName("cepEngine")[0]).getObject();
            if (!isVarSet) {
                HashSet<String> itemsListSet = new HashSet<String>();
                itemsListSet.add("Trooper01");
                itemsListSet.add("Trooper010");
                epProvider.getEPRuntime().setVariableValue(ITEM_LIST_VAR, itemsListSet);
                isVarSet = true;
            }
            epProvider.getEPRuntime().sendEvent((Object)earthling);
            this.result.setResultCode(TaskResult.TaskResultCode.SUCCESS);
        }
        catch (Exception e) {
            this.result.setResultCode(TaskResult.TaskResultCode.FAILURE);
            LOGGER.error("Error accessing (or) invoking method on CEP engine :" + e.getMessage(), (Throwable)e);
        }
    }
}

