/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.batch.hbase.test;

import java.util.Collection;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.trpr.dataaccess.hbase.persistence.HBaseCriteria;
import org.trpr.example.batch.hbase.test.entity.HBaseEarthling;
import org.trpr.platform.core.spi.persistence.Criteria;
import org.trpr.platform.core.spi.persistence.PersistenceManager;
import org.trpr.platform.core.spi.persistence.PersistentEntity;
import org.trpr.platform.integration.impl.json.JSONTranscoderImpl;

public class TestHBaseOps
implements Tasklet {
    private static final Log LOG = LogFactory.getLog(TestHBaseOps.class);
    private PersistenceManager persistenceManager;
    private boolean delete = false;

    public RepeatStatus execute(StepContribution arg0, ChunkContext arg1) throws Exception {
        HBaseEarthling testEntity = new HBaseEarthling();
        testEntity.setName("Jone Doe");
        String uid = UUID.randomUUID().toString();
        testEntity.setUid(uid);
        testEntity.setLongValue(new Random().nextLong());
        testEntity.setIntValue(new Random().nextInt(10000));
        testEntity.setDateValue(new Date());
        testEntity.setByteArrayValue(uid.getBytes());
        this.write(testEntity);
        this.update(testEntity);
        this.read(testEntity);
        if (this.delete) {
            this.delete(testEntity);
        }
        this.scan();
        return RepeatStatus.FINISHED;
    }

    private void write(HBaseEarthling e) {
        this.getPersistenceManager().makePersistent((PersistentEntity)e);
        LOG.info((Object)("Persisted record in hbase with UID :: " + e.getUid()));
    }

    private void read(HBaseEarthling e) {
        PersistentEntity result = this.getPersistenceManager().findEntity((PersistentEntity)e);
        if (result != null) {
            LOG.info((Object)("got record with uid from HBase :: " + new JSONTranscoderImpl().marshal((Object)result)));
        } else {
            LOG.info((Object)("NOT FOUND record with uid from HBase :: " + e.getUid()));
        }
    }

    private void update(HBaseEarthling e) {
        e.setName("Updated John Foo 1");
        this.getPersistenceManager().makePersistent((PersistentEntity)e);
        LOG.info((Object)("Updated record in hbase with UID :: " + e.getUid()));
    }

    private void delete(HBaseEarthling e) {
        this.getPersistenceManager().makeTransient((PersistentEntity)e);
        LOG.info((Object)("got record with uid from HBase :: " + e.getUid()));
    }

    private void scan() {
        HBaseCriteria criteria = new HBaseCriteria();
        criteria.setManagedClass(HBaseEarthling.class);
        criteria.setMaxResults(100);
        Collection entities = this.getPersistenceManager().findEntities((Criteria)criteria);
        LOG.info((Object)("******   Scan output for no. of entities : " + entities.size()));
        for (PersistentEntity entity : entities) {
            try {
                LOG.info((Object)entity.toString());
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to retrieve records with ID : " + ((HBaseEarthling)entity).getUid()));
            }
        }
        LOG.info((Object)("******   Scan complete for no. of entities : " + entities.size()));
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }
}

