/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.hbase.persistence;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.trpr.dataaccess.hbase.HTablePool;
import org.trpr.dataaccess.hbase.auth.AuthenticationProvider;
import org.trpr.dataaccess.hbase.mappings.config.HBaseMappingContainer;
import org.trpr.dataaccess.hbase.model.config.HbaseMapping;
import org.trpr.dataaccess.hbase.persistence.HBaseCriteria;
import org.trpr.dataaccess.hbase.persistence.HBaseHandlerDelegate;
import org.trpr.dataaccess.hbase.persistence.entity.HBaseEntity;
import org.trpr.dataaccess.hbase.serializer.DateSerializer;
import org.trpr.dataaccess.hbase.serializer.IntegerSerializer;
import org.trpr.dataaccess.hbase.serializer.LongSerializer;
import org.trpr.dataaccess.hbase.serializer.StringSerializer;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.impl.persistence.AbstractPersistenceHandler;
import org.trpr.platform.core.impl.persistence.sharding.ShardedEntityContextHolder;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.spi.persistence.Criteria;
import org.trpr.platform.core.spi.persistence.PersistenceException;
import org.trpr.platform.core.spi.persistence.PersistentEntity;
import org.trpr.platform.core.spi.persistence.Serializer;
import org.trpr.platform.core.spi.persistence.sharding.ShardedEntity;
import org.trpr.platform.runtime.spi.config.ConfigurationException;

@ManagedResource(objectName="spring.application:type=Trooper,application=Performance-Metrics,name=HBaseMetrics-", description="HBase Performance Metrics Logger")
public class HBaseHandler
extends AbstractPersistenceHandler
implements InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(HBaseHandler.class);
    private static final int HTABLE_POOL_SIZE = 10;
    private HBaseHandlerDelegate hbaseHandlerDelegate;
    private Map<String, HBaseConfiguration> targetHbaseConfigurations = new HashMap<String, HBaseConfiguration>();
    private Map<String, HTablePool> targetHbaseTablePools = new HashMap<String, HTablePool>();
    private Configuration hbaseConfiguration;
    private HTablePool hbaseTablePool;
    private int htablePoolSize = 10;
    private Boolean useWAL = true;
    private Boolean useAutoFlush = true;
    private HBaseMappingContainer hbaseMappingContainer;
    private Map<String, Serializer> classNameToSerializerMap = new HashMap<String, Serializer>();
    private AuthenticationProvider authProvider;
    private Integer callConnectionValidityCheckMinutes;

    public HBaseHandler() {
        this.classNameToSerializerMap.put("java.lang.String", new StringSerializer());
        this.classNameToSerializerMap.put("java.lang.Long", new LongSerializer());
        this.classNameToSerializerMap.put("java.lang.Integer", new IntegerSerializer());
        this.classNameToSerializerMap.put("java.util.Date", new DateSerializer());
    }

    public void afterPropertiesSet() throws Exception {
        if (this.targetHbaseConfigurations.size() == 0 && this.hbaseConfiguration == null) {
            throw new IllegalArgumentException("targetHbaseConfigurations (or) hbaseConfiguration is required");
        }
        if (this.hbaseConfiguration != null) {
            this.hbaseTablePool = new HTablePool(this.hbaseConfiguration, this.htablePoolSize);
            if (this.getAuthProvider() != null) {
                this.hbaseTablePool.setAuthenticationProvider(this.getAuthProvider());
            }
            this.hbaseTablePool.setCallConnectionValidityCheckMinutes(this.getCallConnectionValidityCheckMinutes());
            this.targetHbaseTablePools.put("", this.hbaseTablePool);
        }
        for (String shard : this.targetHbaseConfigurations.keySet()) {
            this.targetHbaseTablePools.put(shard, new HTablePool((Configuration)this.targetHbaseConfigurations.get(shard), this.htablePoolSize));
        }
        if (this.hbaseHandlerDelegate == null) {
            this.hbaseHandlerDelegate = new HBaseHandlerDelegate(this.hbaseMappingContainer);
        } else {
            this.hbaseHandlerDelegate.setHBaseMappingContainer(this.hbaseMappingContainer);
        }
        HbaseMapping[] hbaseMappingArray = this.hbaseMappingContainer.getMappingForAllClasses();
        int n = hbaseMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            HbaseMapping mapping = hbaseMappingArray[n2];
            LOGGER.info("Warming up HTable pool for : " + mapping.getHbaseClass().getTable());
            HTableInterface table = this.hbaseTablePool.getTable(mapping.getHbaseClass().getTable());
            table.setAutoFlush(this.useAutoFlush.booleanValue());
            table.close();
            for (HTablePool shardedPool : this.targetHbaseTablePools.values()) {
                HTableInterface shardTable = shardedPool.getTable(mapping.getHbaseClass().getTable());
                shardTable.setAutoFlush(this.useAutoFlush.booleanValue());
                shardTable.close();
            }
            ++n2;
        }
        this.hbaseHandlerDelegate.setUseAutoFlush(this.useAutoFlush);
        this.hbaseHandlerDelegate.setUseWAL(this.useWAL);
    }

    public HbaseMapping getMappingForClass(String className) {
        return this.hbaseMappingContainer.getMappingForClass(className);
    }

    public void setHbaseConfigProps(Properties props) {
        this.hbaseConfiguration = HBaseConfiguration.create();
        for (Object key : props.keySet()) {
            this.hbaseConfiguration.set(key.toString(), props.getProperty(key.toString()));
        }
    }

    public void setHbaseMappings(List<String> mappingFileNameList) throws ConfigurationException {
        this.hbaseMappingContainer = new HBaseMappingContainer();
        this.hbaseMappingContainer.init(mappingFileNameList);
    }

    public void setClassNameToSerializerMap(Map<String, Serializer> classNameToSerializerMap) {
        this.classNameToSerializerMap.putAll(classNameToSerializerMap);
    }

    public void setHbaseTablePool(HTablePool hbaseTablePool) {
        this.hbaseTablePool = hbaseTablePool;
    }

    protected HTablePool getHbaseTablePool(HBaseEntity entity) {
        HTablePool tablePool = this.hbaseTablePool;
        ShardedEntity shardedEntity = ShardedEntityContextHolder.getShardedEntity();
        if (shardedEntity != null) {
            if (!shardedEntity.getShardHint().equals(entity.getShardHint())) {
                LOGGER.error("The sharded entity in context does not match the passed in value. Context entity shard is : [" + shardedEntity.getShardHint() + "], passed-in entity shard hint is [" + entity.getShardHint() + "]");
                throw new IllegalStateException("The sharded entity in context does not match the passed in value. Context entity shard is : [" + shardedEntity.getShardHint() + "], passed-in entity shard hint is [" + entity.getShardHint() + "]");
            }
            tablePool = this.targetHbaseTablePools.containsKey(shardedEntity.getShardHint()) ? this.targetHbaseTablePools.get(shardedEntity.getShardHint()) : this.targetHbaseTablePools.get("");
            if (tablePool == null) {
                LOGGER.error("Cannot determine target HBase Configuration for lookup key [" + shardedEntity.getShardHint() + "]");
                throw new IllegalStateException("Cannot determine target HBase Configuration for lookup key [" + shardedEntity.getShardHint() + "]");
            }
        }
        return tablePool;
    }

    public PersistentEntity makePersistent(PersistentEntity entity) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        PersistentEntity persistentEntity = this.hbaseHandlerDelegate.makePersistent((HBaseEntity)entity, this.getHbaseTablePool((HBaseEntity)entity));
        this.performanceMetricsLogger.logPerformanceMetrics("HBaseHandler.makePersistent", entity.toString());
        return persistentEntity;
    }

    public void makeTransient(PersistentEntity entity) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        this.hbaseHandlerDelegate.makeTransient((HBaseEntity)entity, this.getHbaseTablePool((HBaseEntity)entity));
        this.performanceMetricsLogger.logPerformanceMetrics("HBaseHandler.makeTransient", entity.toString());
    }

    public PersistentEntity findEntity(PersistentEntity entity) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        HBaseEntity persistentEntity = this.hbaseHandlerDelegate.findEntity(this.getHbaseTablePool((HBaseEntity)entity), (HBaseEntity)entity, this.getMappingForClass(entity.getClass().getName()));
        this.performanceMetricsLogger.logPerformanceMetrics("HBaseHandler.findEntity", entity.toString());
        return persistentEntity;
    }

    public Collection<PersistentEntity> findEntities(Criteria criteria) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        try {
            Collection<PersistentEntity> persistentEntities;
            Collection<PersistentEntity> collection = persistentEntities = this.hbaseHandlerDelegate.findEntities(this.getHbaseTablePool((HBaseEntity)((Object)criteria.getManagedClass().newInstance())), (HBaseCriteria)criteria, this.getMappingForClass(criteria.getManagedClass().getName()));
            return collection;
        }
        catch (Exception e) {
            LOGGER.error("Error while reading data :: ", (Throwable)e);
            throw new PersistenceException("Error while reading data :: ", (Throwable)e);
        }
        finally {
            this.performanceMetricsLogger.logPerformanceMetrics("HBaseHandler.findEntities", criteria.toConciseString());
        }
    }

    public Configuration getHbaseConfiguration() {
        return this.hbaseConfiguration;
    }

    public void setHbaseConfiguration(HBaseConfiguration hbaseConfiguration) {
        this.hbaseConfiguration = hbaseConfiguration;
    }

    public void setUseWAL(Boolean useWAL) {
        this.useWAL = useWAL;
    }

    public Boolean getUseWAL() {
        return this.useWAL;
    }

    public void setUseAutoFlush(Boolean useAutoFlush) {
        this.useAutoFlush = useAutoFlush;
    }

    public Boolean getUseAutoFlush() {
        return this.useAutoFlush;
    }

    public void setHtablePoolSize(int htablePoolSize) {
        this.htablePoolSize = htablePoolSize;
    }

    public int getHtablePoolSize() {
        return this.htablePoolSize;
    }

    public AuthenticationProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(AuthenticationProvider authProvider) {
        this.authProvider = authProvider;
    }

    public void setCallConnectionValidityCheckMinutes(Integer callConnectionValidityCheckMinutes) {
        this.callConnectionValidityCheckMinutes = callConnectionValidityCheckMinutes;
    }

    public Integer getCallConnectionValidityCheckMinutes() {
        return this.callConnectionValidityCheckMinutes;
    }

    public int update(Criteria criteria) throws PersistenceException {
        throw new UnsupportedOperationException("Operation not supported!!!!!");
    }

    public PersistentEntity findEntity(Criteria criteria) throws PersistenceException {
        throw new UnsupportedOperationException("Operation not supported!!!!!");
    }
}

