/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.hbase.auth.kerberos;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.dataaccess.hbase.auth.AuthenticationProvider;

public class KerberosAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final String KERBEROS = "kerberos";
    private static final String KERBEROS_CONFIG_SYSTEM_VARIABLE = "java.security.krb5.conf";
    private Properties kerberosAuthProperties;
    private String kerberosConfigLocation;
    private String kerberosKeytabLocation;
    private String kerberosPrincipal;

    @Override
    public void authenticatePrincipal(Configuration configuration) throws SecurityException {
        for (Object key : this.kerberosAuthProperties.keySet()) {
            configuration.set(key.toString(), this.kerberosAuthProperties.getProperty(key.toString()));
        }
        System.setProperty(KERBEROS_CONFIG_SYSTEM_VARIABLE, this.kerberosConfigLocation);
        try {
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)this.kerberosPrincipal, (String)this.kerberosKeytabLocation);
        }
        catch (Exception e) {
            throw new SecurityException("Error authenticating Kerberos Principal : " + this.kerberosPrincipal + " .Error message : " + e.getMessage(), e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.kerberosConfigLocation, (String)"The 'kerberosConfigLocation' may not be null");
        Assert.notNull((Object)this.kerberosKeytabLocation, (String)"The 'kerberosKeytabLocation' may not be null");
        Assert.notNull((Object)this.kerberosPrincipal, (String)"The 'kerberosPrincipal' may not be null");
        Assert.notNull((Object)this.kerberosAuthProperties, (String)"The 'kerberosAuthProperties' may not be null");
        if (this.kerberosAuthProperties.getProperty("hadoop.security.authentication") == null || !this.kerberosAuthProperties.getProperty("hadoop.security.authentication").equalsIgnoreCase(KERBEROS)) {
            throw new SecurityException("Property : hadoop.security.authentication must be of value : kerberos");
        }
    }

    public Properties getKerberosAuthProperties() {
        return this.kerberosAuthProperties;
    }

    public void setKerberosAuthProperties(Properties kerberosAuthProperties) {
        this.kerberosAuthProperties = kerberosAuthProperties;
    }

    public String getKerberosConfigLocation() {
        return this.kerberosConfigLocation;
    }

    public void setKerberosConfigLocation(String kerberosConfigLocation) {
        this.kerberosConfigLocation = kerberosConfigLocation;
    }

    public String getKerberosKeytabLocation() {
        return this.kerberosKeytabLocation;
    }

    public void setKerberosKeytabLocation(String kerberosKeytabLocation) {
        this.kerberosKeytabLocation = kerberosKeytabLocation;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }
}

