/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring;

import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.retry.ExponentialBackoffRetry;
import org.springframework.beans.factory.FactoryBean;

public class CuratorClientFactory
implements FactoryBean<CuratorFramework> {
    private static final String TRPR_NAMESPACE = "Trooper";
    private static final int DEFAULT_RETRY_COUNT = 10;
    private static final int DEFAULT_BASE_SLEEP_MS = 1000;
    private static CuratorFramework curatorClient;
    private String zkConnectString;
    private int connectionRetryCount = 10;
    private int baseSleepMillis = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CuratorFramework getObject() throws Exception {
        Class<CuratorClientFactory> clazz = CuratorClientFactory.class;
        synchronized (CuratorClientFactory.class) {
            if (curatorClient == null) {
                curatorClient = CuratorFrameworkFactory.builder().namespace(TRPR_NAMESPACE).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.baseSleepMillis, this.connectionRetryCount)).connectString(this.zkConnectString).build();
                curatorClient.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return curatorClient;
        }
    }

    public Class<CuratorFramework> getObjectType() {
        return CuratorFramework.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getZkConnectString() {
        return this.zkConnectString;
    }

    public void setZkConnectString(String zkConnectString) {
        this.zkConnectString = zkConnectString;
    }

    public int getConnectionRetryCount() {
        return this.connectionRetryCount;
    }

    public void setConnectionRetryCount(int connectionRetryCount) {
        this.connectionRetryCount = connectionRetryCount;
    }

    public int getBaseSleepMillis() {
        return this.baseSleepMillis;
    }

    public void setBaseSleepMillis(int baseSleepMillis) {
        this.baseSleepMillis = baseSleepMillis;
    }
}

