/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.job.ha.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.trpr.platform.batch.common.JobHost;
import org.trpr.platform.batch.impl.job.ha.service.FileUpload;
import org.trpr.platform.batch.spi.spring.admin.JobConfigurationService;
import org.trpr.platform.batch.spi.spring.admin.SyncService;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class SyncServiceImpl
implements SyncService {
    private static final Logger LOGGER = LogFactory.getLogger(SyncServiceImpl.class);
    private static final String SUCCESS_STRING = "success";
    private static final String PROTOCOL = "http://";
    private static final String ENCODING = "UTF-8";
    private JobConfigurationService jobConfigService;
    public int maxRetryCount = 3;

    @Autowired
    public SyncServiceImpl(JobConfigurationService jobConfigurationService) {
        this.jobConfigService = jobConfigurationService;
    }

    public void syncAllHosts() {
        for (String jobName : this.jobConfigService.getCurrentHostJobs()) {
            for (JobHost serverName : this.jobConfigService.getAllHostNames()) {
                if (this.jobConfigService.getHostNames(jobName) == null || this.jobConfigService.getHostNames(jobName).contains(serverName)) continue;
                LOGGER.info("Server: " + serverName.getAddress() + " doesnot have " + jobName + ". Hence pushing");
                if (this.pushJobToHostWithRetry(jobName, serverName.getAddress(), this.maxRetryCount)) continue;
                LOGGER.info("Failed to push jobName=" + jobName + " servername = " + serverName.getAddress());
            }
        }
    }

    public void pullRequest(String serverName) {
        try {
            String urlToConnect = PROTOCOL + serverName + "/" + "/sync/pull";
            String data = String.valueOf(URLEncoder.encode("serverName", ENCODING)) + "=" + URLEncoder.encode(this.jobConfigService.getCurrentHostName().getAddress(), ENCODING);
            this.request(data, urlToConnect);
            LOGGER.info("Sent a pull request to " + serverName);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Exception while pull request", (Throwable)e);
        }
    }

    public boolean pushJobToHostWithRetry(String jobName, String serverName, int retryCount) {
        int count = 0;
        while (!this.pushJobToHost(jobName, serverName)) {
            if (++count < retryCount) continue;
            return false;
        }
        return true;
    }

    public boolean pushJobToHost(String jobName, String serverName) {
        serverName = PROTOCOL + serverName + "/sync/push/deploy";
        HttpPost postRequest = new HttpPost(serverName);
        try {
            MultipartEntity multiPartEntity = new MultipartEntity();
            multiPartEntity.addPart("jobName", (ContentBody)new StringBody(jobName));
            FileBody fileBody = new FileBody(this.jobConfigService.getJobConfig(jobName).getFile(), "application/octect-stream");
            multiPartEntity.addPart("jobConfig", (ContentBody)fileBody);
            if (this.jobConfigService.getJobDependencyList(jobName) != null) {
                for (String dependency : this.jobConfigService.getJobDependencyList(jobName)) {
                    File depFile = new File(String.valueOf(this.jobConfigService.getJobStoreURI(jobName).getPath()) + "/lib/" + dependency);
                    FileBody depFileBody = new FileBody(depFile);
                    multiPartEntity.addPart("depFiles[]", (ContentBody)depFileBody);
                }
            }
            postRequest.setEntity((HttpEntity)multiPartEntity);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error("Error while forming multiPart request", (Throwable)ex);
        }
        catch (IOException e) {
            LOGGER.error("Error while forming multiPart request", (Throwable)e);
        }
        String retValue = FileUpload.executeRequest((HttpRequestBase)postRequest);
        LOGGER.info("Server returns: " + retValue);
        return retValue.trim().equalsIgnoreCase(SUCCESS_STRING);
    }

    public void deployJobToAllHosts(String jobName) {
        LOGGER.info("Pushing " + jobName + " to all hosts");
        if (this.jobConfigService.getCurrentHostJobs().contains(jobName) && this.jobConfigService.getAllHostNames() != null) {
            LOGGER.info("Getting list of hosts to push the job to..");
            for (JobHost host : this.jobConfigService.getAllHostNames()) {
                LOGGER.info("JobHost: " + host.getAddress());
                if (host.equals((Object)this.jobConfigService.getCurrentHostName())) continue;
                LOGGER.info("Pushing: " + jobName + " to " + host.getAddress());
                if (this.pushJobToHostWithRetry(jobName, host.getAddress(), this.maxRetryCount)) continue;
                LOGGER.info("Failed to push: " + jobName + " to " + host.getAddress());
            }
        }
    }

    public void deployAllJobsToHost(String hostAddress) {
        if (hostAddress.equals(this.jobConfigService.getCurrentHostName().getAddress())) {
            return;
        }
        LOGGER.info("Pushing all jobs to " + hostAddress);
        for (String jobName : this.jobConfigService.getCurrentHostJobs()) {
            if (!this.pushJobToHostWithRetry(jobName, hostAddress, this.maxRetryCount)) {
                LOGGER.info("Failed to push: " + jobName + " to " + hostAddress);
                continue;
            }
            LOGGER.info("Pushed job " + jobName + " to server: " + hostAddress);
        }
    }

    private String request(String data, String urlToConnect) {
        PrintWriter writer = null;
        OutputStream output = null;
        try {
            String retline;
            URL url = new URL(urlToConnect);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            output = conn.getOutputStream();
            writer = new PrintWriter((Writer)new OutputStreamWriter(output, ENCODING), true);
            writer.println(data);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String finalReturnValue = "";
            while ((retline = reader.readLine()) != null) {
                finalReturnValue = String.valueOf(finalReturnValue) + retline;
            }
            return finalReturnValue;
        }
        catch (IOException e) {
            LOGGER.error("Exception while pushing request", (Throwable)e);
            return "Unexpected exception. See log for details";
        }
    }
}

