/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.jmx;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.admin.jmx.SimpleJobExecutionMetrics;
import org.springframework.batch.admin.jmx.SimpleStepExecutionMetrics;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.context.SmartLifecycle;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MetricType;
import org.springframework.util.Assert;
import org.trpr.platform.batch.impl.spring.jmx.JobAdministrator;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.spi.management.jmx.InstanceAwareMBean;

@ManagedResource(objectName="spring.application:type=Trooper,application=Batch-Management,name=BatchExecutionMetrics-", description="Batch Job statistics")
public class BatchMetricsExporter
extends MBeanExporter
implements SmartLifecycle,
InstanceAwareMBean {
    private static final String BEAN_NAMING_PREFIX = "spring.application:type=Trooper,application=Batch-Management,name=BatchExecutionMetrics-";
    private static final Logger LOGGER = LogFactory.getLogger(BatchMetricsExporter.class);
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private JobAdministrator jobAdministrator;
    private final AnnotationJmxAttributeSource attributeSource = new AnnotationJmxAttributeSource();
    private Set<String> jobKeys = new HashSet<String>();
    private Set<String> stepKeys = new HashSet<String>();

    public BatchMetricsExporter() {
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)new MetadataNamingStrategy((JmxAttributeSource)this.attributeSource));
        this.setAssembler((MBeanInfoAssembler)new MetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource));
    }

    @ManagedAttribute
    public String[] getJobNames() {
        this.registerJobs();
        this.registerSteps();
        return this.jobKeys.toArray(new String[0]);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Job Execution Failure Count")
    public int getJobExecutionFailureCount() {
        Collection jobExecutions;
        int count = 0;
        int start = 0;
        int pageSize = 100;
        do {
            jobExecutions = this.jobAdministrator.getJobService().listJobExecutions(start, pageSize);
            start += pageSize;
            for (JobExecution jobExecution : jobExecutions) {
                if (!jobExecution.getStatus().isUnsuccessful()) continue;
                ++count;
            }
        } while (!jobExecutions.isEmpty());
        return count;
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Job Execution Count")
    public int getJobExecutionCount() {
        return this.jobAdministrator.getJobService().countJobExecutions();
    }

    public void afterPropertiesSet() {
        Assert.state((this.jobAdministrator != null ? 1 : 0) != 0, (String)"A JobAdministrator must be provided");
        super.afterPropertiesSet();
    }

    public boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.registerJobs();
                this.registerSteps();
                this.running = true;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.unregisterBeans();
                this.jobKeys.clear();
                this.stepKeys.clear();
                this.running = false;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public String getMBeanNameSuffix(Object managedBean, String beanKey) {
        return this.jobAdministrator.getJMXBeanNameSuffix();
    }

    public void setJobAdministrator(JobAdministrator jobAdministrator) {
        this.jobAdministrator = jobAdministrator;
    }

    protected void registerBeans() {
    }

    protected String getBeanKeyForJobExecution(String jobName) {
        jobName = this.escapeForObjectName(jobName);
        return String.format(BEAN_NAMING_PREFIX + this.jobAdministrator.getJMXBeanNameSuffix() + ",job=%s", jobName);
    }

    protected String getBeanKeyForStepExecution(String jobName, String stepName) {
        jobName = this.escapeForObjectName(jobName);
        stepName = this.escapeForObjectName(stepName);
        return String.format(BEAN_NAMING_PREFIX + this.jobAdministrator.getJMXBeanNameSuffix() + ",job=%s,step=%s", jobName, stepName);
    }

    private String escapeForObjectName(String value) {
        value = value.replaceAll(" ", "_");
        value = value.replaceAll(",", ";");
        value = value.replaceAll("=", "~");
        value = value.replaceAll(":", "@");
        value = value.replaceAll(",", ";");
        value = value.replaceAll("=", "~");
        return value;
    }

    private void registerJobs() {
        for (String jobName : this.jobAdministrator.getJobService().listJobs(0, Integer.MAX_VALUE)) {
            if (this.jobKeys.contains(jobName)) continue;
            this.jobKeys.add(jobName);
            this.registerBeanNameOrInstance(new SimpleJobExecutionMetrics(this.jobAdministrator.getJobService(), jobName), this.getBeanKeyForJobExecution(jobName));
        }
    }

    private void registerSteps() {
        for (String jobName : this.jobAdministrator.getJobService().listJobs(0, Integer.MAX_VALUE)) {
            Collection<Object> jobExecutions = Collections.emptySet();
            try {
                jobExecutions = this.jobAdministrator.getJobService().listJobExecutionsForJob(jobName, 0, 1);
            }
            catch (NoSuchJobException e) {
                LOGGER.error("Job listed but does not exist", (Throwable)e);
            }
            for (JobExecution jobExecution : jobExecutions) {
                for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                    String stepName = stepExecution.getStepName();
                    String stepKey = String.format("%s/%s", jobName, stepName);
                    if (this.stepKeys.contains(stepKey)) continue;
                    this.stepKeys.add(stepKey);
                    this.registerBeanNameOrInstance(new SimpleStepExecutionMetrics(this.jobAdministrator.getJobService(), jobName, stepName), this.getBeanKeyForStepExecution(jobName, stepName));
                }
            }
        }
    }
}

