/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.util.Assert;
import org.trpr.platform.batch.impl.spring.admin.repository.MapExecutionContextDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapJobExecutionDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapStepExecutionDao;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class MapJobInstanceDao
implements JobInstanceDao {
    private static final String STAR_WILDCARD = "\\*";
    private static final String STAR_WILDCARD_PATTERN = ".*";
    private final Map<String, JobInstance> jobInstances = new ConcurrentHashMap<String, JobInstance>();
    private Queue<String> jobKeys = new ConcurrentLinkedQueue<String>();
    private JobKeyGenerator<JobParameters> jobKeyGenerator = new DefaultJobKeyGenerator();
    private AtomicLong currentId = new AtomicLong(0L);
    private int maxJobInstanceCount;
    private MapJobExecutionDao jobExecutionDao;
    private MapStepExecutionDao stepExecutionDao;
    private MapExecutionContextDao executionContextDao;
    private static final Logger LOGGER = LogFactory.getLogger(MapJobInstanceDao.class);

    public MapJobInstanceDao(int maxExecutionCount) {
        this.maxJobInstanceCount = maxExecutionCount;
    }

    public void clear() {
        this.jobInstances.clear();
    }

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        JobInstance jobInstance = new JobInstance(Long.valueOf(this.currentId.getAndIncrement()), jobName);
        jobInstance.incrementVersion();
        if (this.jobKeys.size() >= this.maxJobInstanceCount) {
            JobInstance toRemove = this.jobInstances.remove(this.jobKeys.remove());
            LOGGER.info("Removing jobInstance: " + toRemove.toString());
            List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(toRemove);
            for (JobExecution execution : executions) {
                LOGGER.info("Removing JobExecution: " + execution.toString());
                this.jobExecutionDao.removeExecution(execution.getId());
                this.stepExecutionDao.removeStepExecutions(execution);
                this.executionContextDao.removeExecutionContext(execution);
            }
        }
        String jobKey = jobName + "|" + this.jobKeyGenerator.generateKey((Object)jobParameters);
        this.jobInstances.put(jobKey, jobInstance);
        this.jobKeys.add(jobKey);
        return jobInstance;
    }

    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        return this.jobInstances.get(jobName + "|" + this.jobKeyGenerator.generateKey((Object)jobParameters));
    }

    public JobInstance getJobInstance(Long instanceId) {
        for (JobInstance instance : this.jobInstances.values()) {
            if (!instance.getId().equals(instanceId)) continue;
            return instance;
        }
        return null;
    }

    public List<String> getJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (JobInstance instance : this.jobInstances.values()) {
            result.add(instance.getJobName());
        }
        Collections.sort(result);
        return result;
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        for (JobInstance instance : this.jobInstances.values()) {
            if (!instance.getJobName().equals(jobName)) continue;
            result.add(instance);
        }
        Collections.sort(result, new Comparator<JobInstance>(){

            @Override
            public int compare(JobInstance o1, JobInstance o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
        int startIndex = Math.min(start, result.size());
        int endIndex = Math.min(start + count, result.size());
        return result.subList(startIndex, endIndex);
    }

    public JobInstance getJobInstance(JobExecution jobExecution) {
        return jobExecution.getJobInstance();
    }

    public MapJobExecutionDao getJobExecutionDao() {
        return this.jobExecutionDao;
    }

    public void setJobExecutionDao(MapJobExecutionDao jobExecutionDao) {
        this.jobExecutionDao = jobExecutionDao;
    }

    public MapStepExecutionDao getStepExecutionDao() {
        return this.stepExecutionDao;
    }

    public void setStepExecutionDao(MapStepExecutionDao stepExecutionDao) {
        this.stepExecutionDao = stepExecutionDao;
    }

    public MapExecutionContextDao getExecutionContextDao() {
        return this.executionContextDao;
    }

    public void setExecutionContextDao(MapExecutionContextDao executionContextDao) {
        this.executionContextDao = executionContextDao;
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        int count = 0;
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            String key = instanceEntry.getKey();
            String curJobName = key.substring(0, key.lastIndexOf("|"));
            if (!curJobName.equals(jobName)) continue;
            ++count;
        }
        if (count == 0) {
            throw new NoSuchJobException("No job instances for job name " + jobName + " were found");
        }
        return count;
    }

    public List<JobInstance> findJobInstancesByName(String jobName, int start, int count) {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        String convertedJobName = jobName.replaceAll(STAR_WILDCARD, STAR_WILDCARD_PATTERN);
        for (Map.Entry<String, JobInstance> instanceEntry : this.jobInstances.entrySet()) {
            JobInstance instance = instanceEntry.getValue();
            if (!instance.getJobName().matches(convertedJobName)) continue;
            result.add(instance);
        }
        this.sortDescending(result);
        return this.subset(result, start, count);
    }

    private void sortDescending(List<JobInstance> result) {
        Collections.sort(result, new Comparator<JobInstance>(){

            @Override
            public int compare(JobInstance o1, JobInstance o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
    }

    private List<JobInstance> subset(List<JobInstance> jobInstances, int start, int count) {
        int startIndex = Math.min(start, jobInstances.size());
        int endIndex = Math.min(start + count, jobInstances.size());
        return jobInstances.subList(startIndex, endIndex);
    }
}

