/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.quartz;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.batch.core.job.flow.FlowJob;
import org.trpr.platform.batch.spi.quartz.ScheduleRepository;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class SimpleScheduleRepository
implements ScheduleRepository {
    private Map<String, Scheduler> jobSchedulers = new HashMap<String, Scheduler>();
    private static final Logger LOGGER = LogFactory.getLogger(SimpleScheduleRepository.class);

    @Override
    public String getCronExpression(String jobName) {
        Trigger trigger;
        String cronExpr = null;
        if (this.jobSchedulers.containsKey(jobName) && (trigger = this.getTriggerFromScheduler(jobName)) instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            cronExpr = cronTrigger.getCronExpression();
        }
        return cronExpr;
    }

    @Override
    public Date getNextFireDate(String jobName) {
        Trigger trigger;
        Date nextFireTime = null;
        if (this.jobSchedulers.containsKey(jobName) && (trigger = this.getTriggerFromScheduler(jobName)) != null) {
            nextFireTime = trigger.getNextFireTime();
        }
        return nextFireTime;
    }

    @Override
    public boolean doesJobExists(String jobName) {
        return this.jobSchedulers.containsKey(jobName);
    }

    @Override
    public void addScheduler(String jobName, Scheduler scheduler) {
        this.jobSchedulers.put(jobName, scheduler);
    }

    @Override
    public Trigger getTriggerFromScheduler(String requiredJobName) {
        Scheduler sch = this.jobSchedulers.get(requiredJobName);
        try {
            for (JobKey jobKey : sch.getJobKeys(GroupMatcher.anyJobGroup())) {
                List triggers = sch.getTriggersOfJob(jobKey);
                JobDetail jd = sch.getJobDetail(jobKey);
                JobDataMap jdm = jd.getJobDataMap();
                FlowJob fj = (FlowJob)jdm.get((Object)"jobName");
                String fjName = fj.getName();
                if (!fjName.equals(requiredJobName)) continue;
                return (Trigger)triggers.get(0);
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("Error getting Trigger from scheduler", (Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, Scheduler> getJobSchedulers() {
        return this.jobSchedulers;
    }
}

