/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin.repository;

import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.trpr.platform.batch.impl.spring.admin.repository.MapExecutionContextDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapJobExecutionDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapJobInstanceDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapStepExecutionDao;

public class MapJobRepositoryFactoryBean
extends org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean {
    private MapJobExecutionDao jobExecutionDao;
    private MapJobInstanceDao jobInstanceDao;
    private MapStepExecutionDao stepExecutionDao;
    private MapExecutionContextDao executionContextDao;
    private static int DEFAULT_MAX_COUNT = 2000;
    private int maxJobInstanceCount = DEFAULT_MAX_COUNT;

    public MapJobRepositoryFactoryBean() {
        this((PlatformTransactionManager)new ResourcelessTransactionManager());
    }

    public MapJobRepositoryFactoryBean(PlatformTransactionManager transactionManager) {
        this.setTransactionManager(transactionManager);
    }

    public void clear() {
        this.jobInstanceDao.clear();
        this.jobExecutionDao.clear();
        this.stepExecutionDao.clear();
        this.executionContextDao.clear();
    }

    protected JobExecutionDao createJobExecutionDao() throws Exception {
        this.jobExecutionDao = new MapJobExecutionDao();
        if (this.jobInstanceDao != null) {
            this.jobInstanceDao.setJobExecutionDao(this.jobExecutionDao);
        }
        return this.jobExecutionDao;
    }

    protected JobInstanceDao createJobInstanceDao() throws Exception {
        this.jobInstanceDao = new MapJobInstanceDao(this.maxJobInstanceCount);
        this.jobInstanceDao.setExecutionContextDao(this.executionContextDao);
        this.jobInstanceDao.setStepExecutionDao(this.stepExecutionDao);
        this.jobInstanceDao.setJobExecutionDao(this.jobExecutionDao);
        return this.jobInstanceDao;
    }

    protected StepExecutionDao createStepExecutionDao() throws Exception {
        this.stepExecutionDao = new MapStepExecutionDao();
        if (this.jobInstanceDao != null) {
            this.jobInstanceDao.setStepExecutionDao(this.stepExecutionDao);
        }
        return this.stepExecutionDao;
    }

    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        this.executionContextDao = new MapExecutionContextDao();
        if (this.jobInstanceDao != null) {
            this.jobInstanceDao.setExecutionContextDao(this.executionContextDao);
        }
        return this.executionContextDao;
    }

    public JobExecutionDao getJobExecutionDao() {
        return this.jobExecutionDao;
    }

    public JobInstanceDao getJobInstanceDao() {
        return this.jobInstanceDao;
    }

    public StepExecutionDao getStepExecutionDao() {
        return this.stepExecutionDao;
    }

    public ExecutionContextDao getExecutionContextDao() {
        return this.executionContextDao;
    }

    public int getMaxCount() {
        return this.maxJobInstanceCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxJobInstanceCount = maxCount;
    }
}

