/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.web;

import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.trpr.platform.batch.spi.spring.admin.JobConfigurationService;
import org.trpr.platform.batch.spi.spring.admin.JobService;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

@Controller
public class SynchronizationController {
    private JobConfigurationService jobConfigService;
    private JobService jobService;
    public static final String PUSH_URL = "/sync/push/deploy";
    public static final String PULL_URL = "/sync/pull";
    public static final String SUCCESS_STRING = "success";
    private static final Logger LOGGER = LogFactory.getLogger(SynchronizationController.class);

    public SynchronizationController(JobService jobService, JobConfigurationService jobConfigService) {
        this.jobConfigService = jobConfigService;
        this.jobService = jobService;
    }

    @ModelAttribute(value="jobName")
    public String getJobName(HttpServletRequest request) {
        String path = request.getPathInfo();
        int index = path.lastIndexOf("jobs/") + 5;
        if (index >= 0) {
            path = path.substring(index);
        }
        return path;
    }

    @RequestMapping(value={"/sync/pull"}, method={RequestMethod.POST})
    public String pullRequest(ModelMap model, @RequestParam String serverName) {
        LOGGER.info("Received a pull request from: " + serverName.trim());
        if (this.jobConfigService.getSyncService() != null) {
            this.jobConfigService.getSyncService().deployAllJobsToHost(serverName.trim());
            model.addAttribute("Message", (Object)SUCCESS_STRING);
        }
        return "sync/Message";
    }

    @RequestMapping(value={"/sync/push/deploy"}, method={RequestMethod.POST})
    public synchronized String jobReceiver(ModelMap model, @RequestParam String jobName, @RequestParam(value="jobConfig") MultipartFile jobConfig, @RequestParam(value="depFiles[]", required=false) MultipartFile[] depFiles) {
        LinkedList<String> jobNames;
        jobName = jobName.trim();
        LOGGER.info("Push job request received for job: " + jobName);
        if (this.jobService.contains(jobName)) {
            LOGGER.info("Warning: " + jobName + " already exists. Modifying old file");
        }
        try {
            jobNames = new LinkedList<String>();
            jobNames.add(jobName);
            this.jobConfigService.setJobConfig(jobNames, (Resource)new ByteArrayResource(jobConfig.getBytes()));
            LOGGER.info("Success in deploying configuration file for: " + jobName);
            model.addAttribute("Message", (Object)SUCCESS_STRING);
        }
        catch (Exception e) {
            model.addAttribute("Message", (Object)"Error while writing the job config file");
            LOGGER.warn("Unable to deploy the job. Please check that you have write permission. Nested exception: " + e.getMessage());
            return "sync/Message";
        }
        if (depFiles != null && depFiles.length != 0) {
            for (MultipartFile depFile : depFiles) {
                try {
                    LOGGER.info("Request to deploy file: " + jobName + " " + depFile.getOriginalFilename() + " " + depFile.getSize());
                    LinkedList<String> jobNames2 = new LinkedList<String>();
                    jobNames2.add(jobName);
                    this.jobConfigService.addJobDependency(jobNames2, depFile.getOriginalFilename(), depFile.getBytes());
                    LOGGER.info("Success in deploying dependency file for: " + jobName);
                    model.addAttribute("Message", (Object)SUCCESS_STRING);
                }
                catch (Exception e) {
                    LOGGER.error("Exception while deploying Dependency file: ", (Throwable)e);
                    model.addAttribute("Message", (Object)("Unexpected error while deploying dependencyFile: " + depFile.getOriginalFilename()));
                }
            }
        }
        LOGGER.info("Deploy request");
        try {
            jobNames = new LinkedList();
            jobNames.add(jobName);
            this.jobConfigService.deployJob(jobNames);
            LOGGER.info("Success in deploying: " + jobName);
            model.addAttribute("Message", (Object)SUCCESS_STRING);
        }
        catch (Exception e) {
            LOGGER.error("Error while deploying job: " + jobName, (Throwable)e);
            model.addAttribute("Message", (Object)("Unexpected error while loading: " + jobName));
        }
        return "sync/Message";
    }
}

