/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.client;

import org.trpr.platform.batch.impl.spring.jmx.JMXJobUtils;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.impl.bootstrap.spring.Bootstrap;

public class StandAloneBatchClient {
    private static final Logger LOGGER = LogFactory.getLogger(StandAloneBatchClient.class);

    public static void main(String[] args) throws PlatformException {
        if (args.length < 2) {
            LOGGER.error("Batch information is not sufficient. bootstrap config path, batch job name are required parameters");
            throw new PlatformException("Batch Job information is not sufficient");
        }
        String bootstrapConfigPath = args[0];
        String jobName = args[1];
        Bootstrap bootstrap = new Bootstrap();
        System.out.println("Bootstrap Config Path: " + bootstrapConfigPath);
        bootstrap.init(bootstrapConfigPath);
        try {
            JMXJobUtils jmxJobUtils = new JMXJobUtils();
            LOGGER.info("Invoking Trooper Job execution for : " + jobName);
            jmxJobUtils.runJob(jobName);
            String status = jmxJobUtils.waitForJobExecution(jobName, 1000L);
            LOGGER.info("Going to terminate Trooper as Job execution has completed with status : " + status);
        }
        catch (Throwable e) {
            LOGGER.error("Exception running the job", e);
            throw new PlatformException(e);
        }
        finally {
            try {
                bootstrap.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Exception thrown while destroying Platform ", (Throwable)e);
                throw new PlatformException((Throwable)e);
            }
        }
    }
}

