/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.batch.admin.web.TableUtils;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.trpr.platform.batch.common.JobHost;
import org.trpr.platform.batch.common.JobInfo;
import org.trpr.platform.batch.spi.spring.admin.JobConfigurationService;
import org.trpr.platform.batch.spi.spring.admin.JobService;

@Controller
public class JobController
extends org.springframework.batch.admin.web.JobController {
    private JobService jobService;
    private JobConfigurationService jobConfigurationService;
    public static final String NOT_FOUND = "not found";

    @Autowired
    private JobController(JobService jobService, JobConfigurationService jobConfigurationService) {
        super((org.springframework.batch.admin.service.JobService)jobService);
        this.jobService = jobService;
        this.jobConfigurationService = jobConfigurationService;
    }

    @RequestMapping(value={"/jobs", "/configuration"}, method={RequestMethod.GET})
    public void jobs(ModelMap model, @RequestParam(defaultValue="0") int startJob, @RequestParam(defaultValue="20") int pageSize) {
        int total = this.jobService.countJobs();
        TableUtils.addPagination((Map)model, (int)total, (int)startJob, (int)pageSize, (String)"Job");
        Collection names = this.jobService.listJobs(startJob, pageSize);
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (String name : names) {
            int count = 0;
            try {
                count = this.jobService.countJobExecutionsForJob(name);
            }
            catch (NoSuchJobException e) {
                // empty catch block
            }
            boolean launchable = this.jobService.isLaunchable(name);
            boolean incrementable = this.jobService.isIncrementable(name);
            String cronExp = this.jobService.getCronExpression(name);
            if (cronExp == null) {
                cronExp = NOT_FOUND;
            }
            Date nextFireDate = this.jobService.getNextFireDate(name);
            JobInfo jobInfo = new JobInfo(name, count, null, launchable, incrementable, cronExp, nextFireDate);
            List<JobHost> listOfHosts = this.jobConfigurationService.getHostNames(name);
            if (listOfHosts != null) {
                model.addAttribute("host", (Object)"true");
                for (JobHost host : listOfHosts) {
                    jobInfo.addHost(host);
                }
            }
            jobs.add(jobInfo);
        }
        model.addAttribute("newjobs", jobs);
    }
}

