/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring;

import java.io.File;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.trpr.platform.batch.impl.spring.SpringBatchComponentContainer;

public class BatchConfigInfo {
    public static final String BINARIES_PATH = "lib";
    public static final String FILE_PREFIX = "file:";
    private File jobConfigXML;
    private String binariesPath = "lib";
    private AbstractApplicationContext jobContext;

    public BatchConfigInfo(File jobConfigXML) {
        this.jobConfigXML = jobConfigXML;
    }

    public BatchConfigInfo(File jobConfigXML, String binariesPath) {
        this(jobConfigXML);
        this.binariesPath = binariesPath;
    }

    public BatchConfigInfo(File jobConfigXML, String binariesPath, AbstractApplicationContext jobContext) {
        this(jobConfigXML, binariesPath);
        this.jobContext = jobContext;
    }

    protected AbstractApplicationContext loadJobContext(ClassLoader classLoader) {
        ClassLoader existingTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this.jobContext = new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + this.jobConfigXML.getAbsolutePath()}, (ApplicationContext)SpringBatchComponentContainer.getCommonBatchBeansContext());
        Thread.currentThread().setContextClassLoader(existingTCCL);
        return this.jobContext;
    }

    public boolean equals(Object object) {
        BatchConfigInfo otherConfigInfo = (BatchConfigInfo)object;
        return this.getJobConfigXML().getAbsolutePath().equalsIgnoreCase(otherConfigInfo.getJobConfigXML().getAbsolutePath());
    }

    public AbstractApplicationContext getJobContext() {
        return this.jobContext;
    }

    public File getJobConfigXML() {
        return this.jobConfigXML;
    }

    public String getBinariesPath() {
        return this.binariesPath;
    }
}

