/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.trpr.platform.batch.common.utils.ConfigFileUtils;
import org.trpr.platform.batch.spi.spring.admin.JobConfigurationService;
import org.trpr.platform.batch.spi.spring.admin.JobService;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

@Controller
public class JobConfigController {
    private JobService jobService;
    private JobConfigurationService jobConfigService;
    private static final Logger LOGGER = LogFactory.getLogger(JobConfigController.class);

    @Autowired
    public JobConfigController(JobService jobService, JobConfigurationService jobConfigService) {
        this.jobService = jobService;
        this.jobConfigService = jobConfigService;
    }

    @ModelAttribute(value="jobName")
    public String getJobName(HttpServletRequest request) {
        String path = request.getPathInfo();
        int index = path.lastIndexOf("jobs/") + 5;
        if (index >= 0) {
            path = path.substring(index);
        }
        return path;
    }

    @RequestMapping(value={"/configuration/modify/jobs/{jobName}"}, method={RequestMethod.GET})
    public String modifyJob(ModelMap model, @ModelAttribute(value="jobName") String jobName) {
        jobName = jobName.substring(jobName.lastIndexOf(47) + 1);
        model.addAttribute("XMLFileContents", (Object)ConfigFileUtils.getContents(this.jobConfigService.getJobConfig(jobName)).trim());
        model.addAttribute("jobName", ConfigFileUtils.getJobName(this.jobConfigService.getJobConfig(jobName)));
        if (this.jobConfigService.getJobDependencyList(jobName) != null) {
            model.addAttribute("dependencies", this.jobConfigService.getJobDependencyList(jobName));
        }
        return "configuration/modify/jobs/job";
    }

    @RequestMapping(value={"/configuration/modify_job"}, method={RequestMethod.POST})
    public String addNewJob(ModelMap model, @RequestParam MultipartFile jobFile) {
        String jobFileName = jobFile.getOriginalFilename();
        if (jobFile.isEmpty() || jobFileName.lastIndexOf(46) < 0) {
            model.remove((Object)"jobFile");
            model.addAttribute("Error", (Object)"File is Empty or invalid. Only .xml files can be uploaded");
            return "redirect:/configuration";
        }
        if (!jobFileName.substring(jobFileName.lastIndexOf(46)).equals(".xml")) {
            model.remove((Object)"jobFile");
            model.addAttribute("Error", (Object)"Only .xml files can be uploaded");
            return "redirect:/configuration";
        }
        boolean invalidJobFile = false;
        List<String> jobNameList = null;
        try {
            byte[] buffer = jobFile.getBytes();
            String XMLFileContents = new String(buffer);
            model.addAttribute("XMLFileContents", (Object)XMLFileContents);
            jobNameList = ConfigFileUtils.getJobName(new ByteArrayResource(jobFile.getBytes()));
            if (jobNameList == null || jobNameList.size() == 0) {
                throw new PlatformException("Empty list");
            }
        }
        catch (UnsupportedEncodingException e) {
            invalidJobFile = true;
        }
        catch (IOException e) {
            invalidJobFile = true;
        }
        catch (PlatformException p) {
            invalidJobFile = true;
        }
        for (String jobName : jobNameList) {
            if (jobName == null || invalidJobFile) {
                model.clear();
                model.addAttribute("Error", (Object)"invalid jobFile. Couldn't find job's name");
                return "redirect:/configuration";
            }
            if (!this.jobService.contains(jobName)) continue;
            model.clear();
            model.addAttribute("Error", (Object)("The JobName '" + jobName + "' already exists. Please choose another name"));
            return "redirect:/configuration";
        }
        model.addAttribute("jobName", (Object)jobNameList);
        return "configuration/modify/jobs/job";
    }

    @RequestMapping(value={"configuration/modify/jobs/{jobName}"}, method={RequestMethod.POST})
    public String editJob(ModelMap model, @RequestParam(value="jobName") String[] jobNames, @RequestParam(defaultValue="") String XMLFileContents, @RequestParam(defaultValue="0") MultipartFile jobFile, @RequestParam(defaultValue="0") MultipartFile depFile, @RequestParam(defaultValue="0") String identifier) throws Exception {
        List<String> jobNameList = Arrays.asList(jobNames);
        String jobName = jobNameList.get(0);
        if (identifier.equals("Upload file")) {
            String jobFileName = jobFile.getOriginalFilename();
            if (jobFile.isEmpty() || jobFileName.lastIndexOf(46) < 0) {
                model.addAttribute("XMLFileError", (Object)"File is Empty or invalid. Only .xml files can be uploaded");
            } else if (!jobFileName.substring(jobFileName.lastIndexOf(46)).equals(".xml")) {
                model.addAttribute("XMLFileError", (Object)"Only .xml files can be uploaded");
            } else {
                byte[] buffer = jobFile.getBytes();
                XMLFileContents = new String(buffer);
                model.addAttribute("XMLFileContents", (Object)XMLFileContents);
            }
        } else if (identifier.equals("Upload dependency")) {
            String depFileName = depFile.getOriginalFilename();
            if (depFile.isEmpty() || depFileName.lastIndexOf(46) < 0) {
                model.addAttribute("DepFileError", (Object)"File is Empty or invalid. Only .jar files can be uploaded");
            } else if (!depFileName.substring(depFileName.lastIndexOf(46)).equals(".jar")) {
                model.addAttribute("DepFileError", (Object)"Only .jar files can be uploaded");
            } else {
                if (this.jobConfigService.getJobDependencyList(jobName) != null && this.jobConfigService.getJobDependencyList(jobName).contains(depFileName)) {
                    model.addAttribute("DepFileError", (Object)"The filename is already added. Overwriting");
                }
                this.jobConfigService.addJobDependency(jobNameList, depFile.getOriginalFilename(), depFile.getBytes());
            }
        } else {
            LOGGER.info("Request to deploy jobConfig file for: " + jobNameList);
            try {
                this.jobConfigService.setJobConfig(jobNameList, (Resource)new ByteArrayResource(XMLFileContents.getBytes()));
                this.jobConfigService.deployJob(jobNameList);
            }
            catch (Exception e) {
                LOGGER.info("Error while deploying job", (Throwable)e);
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                model.addAttribute("LoadingError", (Object)errors.toString());
                if (errors.toString() == null) {
                    model.addAttribute("LoadingError", (Object)"Unexpected error");
                }
                model.addAttribute("XMLFileContents", (Object)XMLFileContents.trim());
                model.addAttribute("jobName", jobNameList);
                if (this.jobConfigService.getJobDependencyList(jobName) != null) {
                    model.addAttribute("dependencies", this.jobConfigService.getJobDependencyList(jobName));
                }
                model.addAttribute("XMLFileContents", (Object)XMLFileContents.trim());
                return "configuration/modify/jobs/job";
            }
            if (this.jobConfigService.getSyncService() != null) {
                this.jobConfigService.getSyncService().deployJobToAllHosts(jobName);
            }
            model.addAttribute("SuccessMessage", (Object)"The job was successfully deployed!");
            model.addAttribute("jobName", (Object)jobName);
            if (this.jobConfigService.getJobDependencyList(jobName) != null) {
                model.addAttribute("dependencies", this.jobConfigService.getJobDependencyList(jobName));
            }
            model.addAttribute("XMLFileContents", (Object)XMLFileContents.trim());
            String jobDirectory = this.jobConfigService.getJobStoreURI(jobName).getPath();
            model.addAttribute("JobDirectoryName", (Object)(String.valueOf(jobDirectory.substring(jobDirectory.lastIndexOf(47) + 1)) + "/lib"));
            return "configuration/jobs/job";
        }
        model.addAttribute("jobName", jobNameList);
        if (this.jobConfigService.getJobDependencyList(jobName) != null) {
            model.addAttribute("dependencies", this.jobConfigService.getJobDependencyList(jobName));
        }
        model.addAttribute("XMLFileContents", (Object)XMLFileContents);
        return "configuration/modify/jobs/job";
    }

    @RequestMapping(value={"/configuration/jobs/{jobName}"}, method={RequestMethod.GET})
    public String viewConfigDetails(ModelMap model, @ModelAttribute(value="jobName") String jobName, Errors errors, @RequestParam(defaultValue="0") int startJobInstance, @RequestParam(defaultValue="20") int pageSize) throws IOException {
        jobName = jobName.substring(jobName.lastIndexOf(47) + 1);
        model.addAttribute("jobName", (Object)jobName);
        String XMLFileContents = ConfigFileUtils.getContents(this.jobConfigService.getJobConfig(jobName));
        model.addAttribute("XMLFileName", (Object)this.jobConfigService.getJobConfig(jobName).getFilename());
        model.addAttribute("XMLFileContents", (Object)XMLFileContents);
        String jobDirectory = this.jobConfigService.getJobStoreURI(jobName).getPath();
        model.addAttribute("JobDirectoryName", (Object)(String.valueOf(jobDirectory.substring(jobDirectory.lastIndexOf(47) + 1)) + "/lib"));
        if (this.jobConfigService.getJobDependencyList(jobName) != null) {
            model.addAttribute("dependencies", this.jobConfigService.getJobDependencyList(jobName));
        }
        return "configuration/jobs/job";
    }
}

