/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.jmx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.trpr.platform.batch.model.statistics.jobstatistics.JobStatistics;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.spi.management.jmx.AppInstanceAwareMBean;

@ManagedResource(objectName="spring.application:type=Trooper,application=Batch-Management,name=JobAdministrator-", description="Batch Job Administration Interface")
public class JobAdministrator
extends AppInstanceAwareMBean {
    private static final Logger LOGGER = LogFactory.getLogger(JobAdministrator.class);
    private static final String UNKNOWN_HOST = "Unresolved Host IP";
    private static ArrayType STEP_JMX_TYPE;
    private static final String[] ATTRIBUTE_NAMES;
    private static final String[] ATTRIBUTE_DESCRIPTIONS;
    private static final OpenType[] ATTRIBUTE_TYPES;
    private static final String[] INDEX_NAMES;
    private static CompositeType compositeType;
    private static TabularType tableType;
    private TabularDataSupport batchInvocationStatistics = new TabularDataSupport(tableType);
    private String hostIP;
    private Calendar hostStartTimeStamp;
    private JobOperator jobOperator;
    private JobExplorer jobExplorer;
    private JobService jobService;

    static {
        try {
            STEP_JMX_TYPE = new ArrayType(1, SimpleType.STRING);
        }
        catch (OpenDataException openDataException) {
            // empty catch block
        }
        ATTRIBUTE_NAMES = new String[]{"hostIP", "hostStartTime", "jobName", "jobStatus", "jobSteps", "jobStepInError", "jobMessage", "jobStartTime", "jobEndTime"};
        ATTRIBUTE_DESCRIPTIONS = new String[]{"Host IP", "Host Start Time", "Job name", "Job last execution status", "Job steps", "Error step in job execution", "Job last execution message", "Job last execution start", "Job last execution end"};
        ATTRIBUTE_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, STEP_JMX_TYPE, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.DATE};
        INDEX_NAMES = new String[]{"hostIP", "jobName"};
        try {
            compositeType = new CompositeType("jobStatistics", "Job statistics", ATTRIBUTE_NAMES, ATTRIBUTE_DESCRIPTIONS, ATTRIBUTE_TYPES);
            tableType = new TabularType("listOfJobStatistics", "List of Job statistics", compositeType, INDEX_NAMES);
        }
        catch (Exception e) {
            LOGGER.error("Error initializing JMX types used in job statistics monitoring : " + e.getMessage(), (Throwable)e);
        }
    }

    public JobAdministrator() {
        try {
            this.hostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.hostIP = UNKNOWN_HOST;
        }
        this.hostStartTimeStamp = Calendar.getInstance();
    }

    public String getJMXBeanNameSuffix() {
        return this.getMBeanNameSuffix(null, null);
    }

    @ManagedAttribute
    public TabularDataSupport getIndividualJobExecutionMetrics() {
        this.populateJobStatistics();
        return this.batchInvocationStatistics;
    }

    @ManagedOperation
    public void runJob(String jobName) throws PlatformException {
        String registryJobName = null;
        for (String job : this.getJobOperator().getJobNames()) {
            if (!job.equalsIgnoreCase(jobName)) continue;
            registryJobName = job;
            break;
        }
        if (registryJobName == null) {
            String jobDoesnotExist = "Error executing jobs. No jobs found in the registry that match : " + jobName;
            LOGGER.error(jobDoesnotExist);
            throw new PlatformException(jobDoesnotExist);
        }
        try {
            this.getJobOperator().startNextInstance(registryJobName);
        }
        catch (Exception e) {
            String jobExecutionError = "Error triggering job execution: " + e.getMessage();
            LOGGER.error(jobExecutionError, (Throwable)e);
            throw new PlatformException(jobExecutionError, (Throwable)e);
        }
    }

    private void populateJobStatistics() {
        JobStatistics[] stats;
        this.batchInvocationStatistics.clear();
        JobStatistics[] jobStatisticsArray = stats = this.getStats();
        int n = stats.length;
        int n2 = 0;
        while (n2 < n) {
            JobStatistics stat = jobStatisticsArray[n2];
            Object[] statValues = new Object[ATTRIBUTE_NAMES.length];
            statValues[0] = stat.getHostIP();
            statValues[1] = stat.getHostStartTimeStamp().getTime();
            statValues[2] = stat.getJobName();
            statValues[3] = stat.getJobStatus();
            statValues[4] = stat.getJobSteps().toArray(new String[0]);
            statValues[5] = stat.getJobStepInError();
            statValues[6] = stat.getJobMessage();
            statValues[7] = stat.getJobStartTimeStamp() == null ? null : stat.getJobStartTimeStamp().getTime();
            statValues[8] = stat.getJobEndTimestamp() == null ? null : stat.getJobEndTimestamp().getTime();
            try {
                CompositeDataSupport compositeData = new CompositeDataSupport(compositeType, ATTRIBUTE_NAMES, statValues);
                this.batchInvocationStatistics.put(compositeData);
            }
            catch (OpenDataException e) {
                LOGGER.error("Error constructing JMX data type from job statistics. Error is : " + e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    private JobStatistics[] getStats() {
        JobStatistics[] jobStatistics = new JobStatistics[this.getJobOperator().getJobNames().size()];
        int count = 0;
        for (String jobName : this.getJobOperator().getJobNames()) {
            jobStatistics[count] = new JobStatistics();
            jobStatistics[count].setHostIP(this.getHostIP());
            jobStatistics[count].setHostStartTimeStamp(this.getHostStartTimeStamp());
            jobStatistics[count].setJobName(jobName);
            List jobInstancesList = this.getJobExplorer().getJobInstances(jobName, 0, 1);
            if (jobInstancesList.size() > 0) {
                JobInstance jobInstance = (JobInstance)jobInstancesList.get(0);
                List jobExecutionList = this.getJobExplorer().getJobExecutions(jobInstance);
                if (jobExecutionList.size() > 0) {
                    JobExecution jobExecution = (JobExecution)jobExecutionList.get(0);
                    jobStatistics[count].setJobStatus(jobExecution.getStatus().name());
                    if (jobExecution.getStatus() == BatchStatus.FAILED) {
                        Collection stepExecutions = jobExecution.getStepExecutions();
                        for (StepExecution step : stepExecutions) {
                            jobStatistics[count].getJobSteps().add(step.getStepName());
                            if (!step.getExitStatus().getExitCode().equals(ExitStatus.FAILED.getExitCode())) continue;
                            jobStatistics[count].setJobStepInError(step.getStepName());
                            jobStatistics[count].setJobMessage(step.getExitStatus().getExitDescription());
                        }
                    } else {
                        jobStatistics[count].setJobMessage(jobExecution.getExitStatus().getExitDescription());
                    }
                    if (jobExecution.getStartTime() != null) {
                        Calendar jobStartTimeStamp = Calendar.getInstance();
                        jobStartTimeStamp.setTime(jobExecution.getStartTime());
                        jobStatistics[count].setJobStartTimeStamp(jobStartTimeStamp);
                    }
                    if (jobExecution.getEndTime() != null) {
                        Calendar jobEndTimeStamp = Calendar.getInstance();
                        jobEndTimeStamp.setTime(jobExecution.getEndTime());
                        jobStatistics[count].setJobEndTimestamp(jobEndTimeStamp);
                    }
                }
            }
            ++count;
        }
        return jobStatistics;
    }

    public void setBatchInvocationStatistics(TabularDataSupport batchInvocationStatistics) {
        this.batchInvocationStatistics = batchInvocationStatistics;
    }

    public JobOperator getJobOperator() {
        return this.jobOperator;
    }

    public void setJobOperator(JobOperator jobOperator) {
        this.jobOperator = jobOperator;
    }

    public JobExplorer getJobExplorer() {
        return this.jobExplorer;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public Calendar getHostStartTimeStamp() {
        return this.hostStartTimeStamp;
    }

    public JobService getJobService() {
        return this.jobService;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

