/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin.repository;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class MapStepExecutionDao
extends org.springframework.batch.core.repository.dao.MapStepExecutionDao {
    private Map<Long, Map<Long, StepExecution>> executionsByJobExecutionId = new ConcurrentHashMap<Long, Map<Long, StepExecution>>();
    private Map<Long, StepExecution> executionsByStepExecutionId = new ConcurrentHashMap<Long, StepExecution>();
    private AtomicLong currentId = new AtomicLong();

    public void clear() {
        this.executionsByJobExecutionId.clear();
        this.executionsByStepExecutionId.clear();
    }

    private static StepExecution copy(StepExecution original) {
        StepExecution copy = new StepExecution(original.getStepName(), original.getJobExecution());
        copy.setCommitCount(original.getCommitCount());
        if (original.getEndTime() != null) {
            copy.setEndTime((Date)original.getEndTime().clone());
        }
        if (original.getExitStatus() != null) {
            copy.setExitStatus(new ExitStatus(original.getExitStatus().getExitCode(), original.getExitStatus().getExitDescription()));
        }
        copy.setFilterCount(original.getFilterCount());
        copy.setId(original.getId());
        if (original.getLastUpdated() != null) {
            copy.setLastUpdated((Date)original.getLastUpdated().clone());
        }
        copy.setProcessSkipCount(original.getProcessSkipCount());
        copy.setReadCount(original.getReadCount());
        copy.setReadSkipCount(original.getReadSkipCount());
        copy.setRollbackCount(original.getRollbackCount());
        if (original.getStartTime() != null) {
            copy.setStartTime((Date)original.getStartTime().clone());
        }
        if (original.getStatus() != null) {
            copy.setStatus(BatchStatus.valueOf((String)original.getStatus().name()));
        }
        if (original.isTerminateOnly()) {
            copy.setTerminateOnly();
        }
        copy.setVersion(original.getVersion());
        copy.setWriteCount(original.getWriteCount());
        copy.setWriteSkipCount(original.getWriteSkipCount());
        return copy;
    }

    private static void copy(final StepExecution sourceExecution, final StepExecution targetExecution) {
        ReflectionUtils.doWithFields(StepExecution.class, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                field.setAccessible(true);
                field.set(targetExecution, field.get(sourceExecution));
            }
        });
    }

    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isTrue((stepExecution.getId() == null ? 1 : 0) != 0);
        Assert.isTrue((stepExecution.getVersion() == null ? 1 : 0) != 0);
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"JobExecution must be saved already.");
        Long jobExecutionID = stepExecution.getJobExecutionId();
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        if (executions == null) {
            executions = new ConcurrentHashMap<Long, StepExecution>();
            this.executionsByJobExecutionId.put(stepExecution.getJobExecutionId(), executions);
        }
        stepExecution.setId(Long.valueOf(this.currentId.incrementAndGet()));
        stepExecution.incrementVersion();
        StepExecution copy = MapStepExecutionDao.copy(stepExecution);
        executions.put(stepExecution.getId(), copy);
        this.executionsByStepExecutionId.put(stepExecution.getId(), copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution.getJobExecutionId());
        if (!this.executionsByJobExecutionId.containsKey(stepExecution.getJobExecutionId())) {
            return;
        }
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        Assert.notNull(executions, (String)"step executions for given job execution are expected to be already saved");
        StepExecution persistedExecution = this.executionsByStepExecutionId.get(stepExecution.getId());
        Assert.notNull((Object)persistedExecution, (String)"step execution is expected to be already saved");
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            if (!persistedExecution.getVersion().equals(stepExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            stepExecution.incrementVersion();
            StepExecution copy = new StepExecution(stepExecution.getStepName(), stepExecution.getJobExecution());
            MapStepExecutionDao.copy(stepExecution, copy);
            executions.put(stepExecution.getId(), copy);
            this.executionsByStepExecutionId.put(stepExecution.getId(), copy);
        }
    }

    public StepExecution getStepExecution(JobExecution jobExecution, Long stepExecutionId) {
        return this.executionsByStepExecutionId.get(stepExecutionId);
    }

    public void addStepExecutions(JobExecution jobExecution) {
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(jobExecution.getId());
        if (executions == null || executions.isEmpty()) {
            return;
        }
        ArrayList<StepExecution> result = new ArrayList<StepExecution>(executions.values());
        Collections.sort(result, new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
        ArrayList<StepExecution> copy = new ArrayList<StepExecution>(result.size());
        for (StepExecution exec : result) {
            copy.add(MapStepExecutionDao.copy(exec));
        }
        jobExecution.addStepExecutions(copy);
    }

    public void removeStepExecutions(JobExecution jobExecution) {
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(jobExecution.getId());
        if (executions == null || executions.isEmpty()) {
            return;
        }
        for (StepExecution step : executions.values()) {
            this.executionsByStepExecutionId.remove(step.getId());
        }
        this.executionsByJobExecutionId.remove(jobExecution.getId());
    }
}

