/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.util.Assert;
import org.trpr.platform.batch.impl.spring.admin.repository.MapExecutionContextDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapJobExecutionDao;
import org.trpr.platform.batch.impl.spring.admin.repository.MapStepExecutionDao;

public class MapJobInstanceDao
implements JobInstanceDao {
    private Queue<JobInstance> jobInstances = new ConcurrentLinkedQueue<JobInstance>();
    private long currentId = 0L;
    private int maxJobInstanceCount;
    private MapJobExecutionDao jobExecutionDao;
    private MapStepExecutionDao stepExecutionDao;
    private MapExecutionContextDao executionContextDao;

    public MapJobInstanceDao(int maxExecutionCount) {
        this.maxJobInstanceCount = maxExecutionCount;
    }

    public void clear() {
        this.jobInstances.clear();
    }

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        JobInstance jobInstance = new JobInstance(Long.valueOf(this.currentId++), jobParameters, jobName);
        jobInstance.incrementVersion();
        if (this.jobInstances.size() >= this.maxJobInstanceCount) {
            JobInstance toRemove = this.jobInstances.remove();
            List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(toRemove);
            for (JobExecution execution : executions) {
                this.jobExecutionDao.removeExecution(execution.getId());
                this.stepExecutionDao.removeStepExecutions(execution);
                this.executionContextDao.removeExecutionContext(execution);
            }
        }
        this.jobInstances.add(jobInstance);
        return jobInstance;
    }

    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        for (JobInstance instance : this.jobInstances) {
            if (!instance.getJobName().equals(jobName) || !instance.getJobParameters().equals((Object)jobParameters)) continue;
            return instance;
        }
        return null;
    }

    public JobInstance getJobInstance(Long instanceId) {
        for (JobInstance instance : this.jobInstances) {
            if (!instance.getId().equals(instanceId)) continue;
            return instance;
        }
        return null;
    }

    public List<String> getJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (JobInstance instance : this.jobInstances) {
            result.add(instance.getJobName());
        }
        Collections.sort(result);
        return result;
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        for (JobInstance instance : this.jobInstances) {
            if (!instance.getJobName().equals(jobName)) continue;
            result.add(instance);
        }
        Collections.sort(result, new Comparator<JobInstance>(){

            @Override
            public int compare(JobInstance o1, JobInstance o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
        int startIndex = Math.min(start, result.size());
        int endIndex = Math.min(start + count, result.size());
        return result.subList(startIndex, endIndex);
    }

    public JobInstance getJobInstance(JobExecution jobExecution) {
        return jobExecution.getJobInstance();
    }

    public MapJobExecutionDao getJobExecutionDao() {
        return this.jobExecutionDao;
    }

    public void setJobExecutionDao(MapJobExecutionDao jobExecutionDao) {
        this.jobExecutionDao = jobExecutionDao;
    }

    public MapStepExecutionDao getStepExecutionDao() {
        return this.stepExecutionDao;
    }

    public void setStepExecutionDao(MapStepExecutionDao stepExecutionDao) {
        this.stepExecutionDao = stepExecutionDao;
    }

    public MapExecutionContextDao getExecutionContextDao() {
        return this.executionContextDao;
    }

    public void setExecutionContextDao(MapExecutionContextDao executionContextDao) {
        this.executionContextDao = executionContextDao;
    }
}

