/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.jetty;

import java.io.File;
import org.mortbay.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.FactoryBean;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class JettyWebAppContextFactory
implements FactoryBean<WebAppContext> {
    public static final int DEFAULT_MAX_FORM_SIZE = 2000000;
    private String contextName;
    private String contextPath;
    private int maxFormContentSize = 2000000;

    public Class<WebAppContext> getObjectType() {
        return WebAppContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public WebAppContext getObject() throws Exception {
        File[] files;
        String path = null;
        File[] fileArray = files = FileLocator.findDirectories((String)this.getContextPath(), null);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileToString = file.toString();
            if (fileToString.contains("batch-core")) {
                path = fileToString;
                break;
            }
            ++n2;
        }
        if (path.contains(".jar!") && path.startsWith("file:/")) {
            path = path.replace("file:/", "jar:file:/");
        }
        if (path.endsWith("WEB-INF")) {
            path = path.replace("WEB-INF", "");
        }
        WebAppContext webAppContext = new WebAppContext(path, this.getContextName());
        webAppContext.setMaxFormContentSize(this.getMaxFormContentSize());
        return webAppContext;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getMaxFormContentSize() {
        return this.maxFormContentSize;
    }

    public void setMaxFormContentSize(int maxFormContentSize) {
        this.maxFormContentSize = maxFormContentSize;
    }
}

