/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.reader;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.batch.spi.spring.reader.BatchItemStreamReader;

public class CompositeItemStreamReader<T>
implements BatchItemStreamReader<T>,
InitializingBean {
    private BatchItemStreamReader<T> delegate;
    private Queue<T> localQueue = new LinkedList<T>();
    private Queue<ExecutionContext> contextList = new LinkedList<ExecutionContext>();
    private CountDownLatch countDownLatch;

    public CompositeItemStreamReader(BatchItemStreamReader<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws Exception, UnexpectedInputException, ParseException {
        CompositeItemStreamReader compositeItemStreamReader = this;
        synchronized (compositeItemStreamReader) {
            if (!this.localQueue.isEmpty()) {
                return this.localQueue.remove();
            }
        }
        ExecutionContext context = null;
        CompositeItemStreamReader compositeItemStreamReader2 = this;
        synchronized (compositeItemStreamReader2) {
            if (!this.contextList.isEmpty()) {
                context = this.contextList.remove();
            }
        }
        if (context != null) {
            T[] items = this.delegate.batchRead(context);
            CompositeItemStreamReader compositeItemStreamReader3 = this;
            synchronized (compositeItemStreamReader3) {
                for (T item : items) {
                    this.localQueue.add(item);
                }
                this.countDownLatch.countDown();
                return this.localQueue.remove();
            }
        }
        this.countDownLatch.await();
        compositeItemStreamReader2 = this;
        synchronized (compositeItemStreamReader2) {
            if (!this.localQueue.isEmpty()) {
                return this.localQueue.remove();
            }
        }
        return null;
    }

    @Override
    public T[] batchRead(ExecutionContext context) throws Exception, UnexpectedInputException, ParseException {
        throw new UnsupportedOperationException("Illegal invocation of batchRead(), call read() instead.");
    }

    public void close() throws ItemStreamException {
        this.delegate.close();
    }

    public void open(ExecutionContext context) throws ItemStreamException {
        this.contextList.add(context);
        if (this.countDownLatch == null || this.countDownLatch.getCount() == 0L) {
            this.countDownLatch = new CountDownLatch(context.getInt("totalPartitions", 1));
        }
    }

    public void update(ExecutionContext context) throws ItemStreamException {
        this.delegate.update(context);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"The 'delegate' may not be null");
    }

    public BatchItemStreamReader<T> getDelegate() {
        return this.delegate;
    }
}

