/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.spi.event.PlatformEventProducer;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrapext.spring.ApplicationContextFactory;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.bootstrapext.BootstrapExtension;
import org.trpr.platform.runtime.spi.component.ComponentContainer;

public class SpringBatchComponentContainer
implements ComponentContainer {
    private static final String FILE_PREFIX = "file:";
    private static final String DEFAULT_EVENT_PRODUCER = "platformEventProducer";
    private static AbstractApplicationContext commonBatchBeansContext;
    private List<AbstractApplicationContext> jobsContextList = new LinkedList<AbstractApplicationContext>();
    private BootstrapExtension[] loadedBootstrapExtensions;

    public static AbstractApplicationContext getCommonBatchBeansContext() {
        return commonBatchBeansContext;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setLoadedBootstrapExtensions(BootstrapExtension ... bootstrapExtensions) {
        this.loadedBootstrapExtensions = bootstrapExtensions;
    }

    public void init() throws PlatformException {
        File[] jobBeansFiles;
        commonBatchBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-batch-config.xml"}, (ApplicationContext)ApplicationContextFactory.getCommonBeansContext());
        this.jobsContextList.add(commonBatchBeansContext);
        if (RuntimeVariables.getRuntimeNature().equalsIgnoreCase("SERVER")) {
            commonBatchBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-batch-server-nature-config.xml"}, (ApplicationContext)commonBatchBeansContext);
        }
        for (File jobBeansFile : jobBeansFiles = FileLocator.findFiles((String)"spring-batch-config.xml")) {
            this.jobsContextList.add((AbstractApplicationContext)new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + jobBeansFile.getAbsolutePath()}, (ApplicationContext)commonBatchBeansContext));
        }
    }

    public void destroy() throws PlatformException {
        for (AbstractApplicationContext context : this.jobsContextList) {
            context.close();
        }
        this.jobsContextList = null;
    }

    public void publishEvent(PlatformEvent event) {
        PlatformEventProducer publisher = (PlatformEventProducer)commonBatchBeansContext.getBean(DEFAULT_EVENT_PRODUCER);
        publisher.publishEvent(event);
    }

    public void publishBootstrapEvent(PlatformEvent bootstrapEvent) {
        this.publishEvent(bootstrapEvent);
    }
}

