/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.jetty;

import java.io.File;
import org.mortbay.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.FactoryBean;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class JettyWebAppContextFactory
implements FactoryBean<WebAppContext> {
    private String contextName;
    private String contextPath;

    public Class<WebAppContext> getObjectType() {
        return WebAppContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public WebAppContext getObject() throws Exception {
        File[] files;
        String path = null;
        for (File file : files = FileLocator.findDirectories((String)this.getContextPath(), null)) {
            String fileToString = file.toString();
            if (!fileToString.contains("batch-core")) continue;
            path = fileToString;
            break;
        }
        if (path.contains(".jar!") && path.startsWith("file:/")) {
            path = path.replace("file:/", "jar:file:/");
        }
        if (path.endsWith("WEB-INF")) {
            path = path.replace("WEB-INF", "");
        }
        return new WebAppContext(path, this.getContextName());
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

