(ns open-scad.models.filament-roll-holder
  (:require [open-scad.core :refer :all]))

(def hole-size       4)

(def bar-width       50)
(def bar-length      5)
(def bar-height      15)
(def rod-diameter    bar-height)
(def rod-height      90)
(def guard-diameter  50)
(def guard-height    bar-length)

(defgeometry roll-holder []
  (let [bar   (cube bar-width bar-length bar-height)
        rod   (cylinder (/ rod-diameter 2) rod-height)
        guard (cylinder (/ guard-diameter 2) guard-height)
        hole  (cylinder (/ hole-size 2) (+ 2 bar-length))]
    (-> bar
        (union (->> rod
                      (rotate [(° 90) 0 0])
                      (translate [0 (- (/ (+ rod-height bar-length) 2)) 0]))
                 (->> guard
                      (rotate [(° 90) 0 0])
                      (translate [0 (- 0
                                       (/ (+ guard-height bar-length) 2)
                                       rod-height)
                                  0])))
        (difference (->> hole
                         (rotate [(° 90) 0 0])
                         (translate [(* 0.4 bar-width) 0 0]))
                    (->> hole
                         (rotate [(° 90) 0 0])
                         (translate [(* -0.4 bar-width) 0 0]))))))

(render ($fn 40 (roll-holder)))
