(ns open-scad.models.water-heater-controller
  (:require [open-scad.core                  :refer :all :exclude [cylinder]]
            [open-scad.models.valve-actuator :refer [servo-cross]]
            [open-scad.libs.nosecones        :refer [cone-elliptical]]
            [open-scad.libs.mcad.servos      :refer [sg-90]]))


(def knob-height   15)
(def base-diameter 35.75)
(def top-diameter  30.75)
(def thick         5)
(def spider-height (+ knob-height 35))

(defgeometry cylinder [& {:keys [h r r1 r2 d d1 d2 center $fn $fa $fs]}])

(defgeometry knob-cap []
  (let [cyl #(cylinder :h  (+ knob-height   %)
                       :d1 (+ base-diameter %)
                       :d2 (+ top-diameter  %))]
    (-> (difference (cyl thick) (cyl 0))
        (difference (->> (servo-cross)
                         (union (cylinder :h 4 :r 4))
                         (rotate [(° 180) 0 0])
                         (translate [0 0 (+ 6 knob-height thick (- 3))])))
        #_(open-scad.core/render))))

(defgeometry knob-spider []
  (-> (difference (cone-elliptical {:R (/ (+ base-diameter thick 30) 2)
                                    :L spider-height
                                    :s (literal "$fn")})
                  (translate [0 0 (- thick)]
                             (cone-elliptical {:R (/ (+ base-diameter thick 20) 2)
                                               :L spider-height
                                               :s (literal "$fn")})))
      (->> (translate [0 5 0]))
      (difference (->> (cube (+ 12 1) (+ 32 1) 22.60)
                       (translate [0 5.4 40]))
                  (->> (cube 100 100 100)
                       (translate [0 0 (+ 50 spider-height -5)]))
                  #_(->> (sg-90 :screws 1 :axle-length 10 :cables 1)
                         (rotate [(° 180) 0 (° 90)])
                         (translate [0 0 (+ knob-height thick 30)])))
      (difference (for [x [+ -]
                        y [+ -]]
                    (translate [(x 1/2 base-diameter) (y 1/2 base-diameter) 0]
                               (cylinder :d 60 :h 50))))
      (union (->> (for [x [+ -]
                        y [+ -]]
                    (->> (sphere 5)
                         (translate [(x 18) (y 18) (- spider-height 10)])
                         (rotate [0 0 (° 45)])))
                  (translate [0 5 0])))))

(render ($fn 100 (union (part :cap (knob-cap))
                        (part :spider (knob-spider)))))

