(ns open-scad.models.ts-600-hole-cap
  (:use clojure.pprint)
  (:refer-clojure :exclude [use import])
  (:require [threading.core :refer :all]
            [weaving.core :refer :all]
            [open-scad.core :refer :all :exclude [cylinder]]
            [open-scad.libs.threads :refer [metric-thread]]))

(def hole-size    (+ 10 0.5))
(def cable-width  (+ 2.55 1))
(def cap-height   15)
(def screw-pitch  2.2)
(def screw-taper  0)
(def screw-leadin 1)
(def bolt-height  3)
(def guard-width  2)
(def guard-height 1.5)

(defgeometry cylinder [& {:keys [h r r1 r2 d d1 d2 center $fa $fs $fn]}])

(defn cap [r h]
  (let [bottom (cylinder :r r :h (/ h 2) :center false)
        guard  (cylinder :r (+ (/ hole-size 2) guard-width) :h guard-height
                         :center false)
        thread #(metric-thread %1 screw-pitch (/ h 2)
                               :taper  (if-not %2 screw-taper  0)
                               :leadin (if-not %2 screw-leadin 0)
                               :internal %2)
        top    (difference (thread (* r 2) false)
                           (translate [0 0 (+ep (/ h 4))]
                                      (cube (* 1/4 cable-width)
                                            (* 3 r)
                                            (/ h 2))
                                      (cube (* 3 r)
                                            (* 1/2 cable-width)
                                            (/ h 2))))
        hole   (•- (cylinder :d cable-width :h (* 3 h) :center true)
                   (<- (hull (-•• (translate [0 (* -1/2 cable-width) 0]))
                             (-•• (translate [0 (*  1/2 cable-width) 0])))))
        bolt   (difference (cylinder :r      (+ (/ hole-size 2) guard-width 2)
                                     :h      bolt-height
                                     :$fn    6
                                     :center false)
                           (translate [0 0 (* -1/2 (/ h 2))]
                                      (thread (+ (* r 2) 1) true)))]
    (-> (part :cap (difference
                     (union bottom
                            (translate [0 0 (- (/ cap-height 2) guard-height)]
                                       guard)
                            (translate [0 0 (/ cap-height 2)]
                                       top))
                     hole))
        (union (translate [(* 3 hole-size) 0 0]
                          (part :bolt bolt))))))

(render ($fn 100 (cap (/ hole-size 2) cap-height)))
