(ns open-scad.libs.dot-scad
  (:require [open-scad.core :refer :all]))

(definclusion 'dotSCAD.-2.2/archimedean_spiral.scad)
(definclusion 'dotSCAD.-2.2/polyline2d.scad)
(definclusion 'dotSCAD.-2.2/rounded_cube.scad)

(defgeometry polyline2d
  [{:keys [points width starting-style ending-style $fa $fs $fn]}])
(defgeometry ^{:foreign-name 'archimedean-spiral} archimedean-spiral*
  [{:keys [arm-distance init-angle point-distance num-of-points rt-dir]}])
(defgeometry archimedean-spiral
  [m]
  [(assign "points_angles" (archimedean-spiral* m))
   (assign "points" (literal "[for(pa = points_angles) pa[0]]"))
   (polyline2d (merge m {:points (literal "points")}))])

(defgeometry rounded-cube [size corner-r & {:keys [center]}])


