(ns open-scad.models.kossel-arm-clip
  (:require [open-scad.core :refer :all]
            [threading.core :refer :all]))

(def arm-diameter 6)
(def clip-length  10)
(def thick        2)

(defgeometry arm-clip []
  (let [cub (-> (cube (+ clip-length (* 2 thick)) (+ clip-length (* 2 thick)) clip-length)
                (difference (cube clip-length clip-length (inc clip-length))))
        cyl (-> (cylinder (+ (* 1/2 arm-diameter) thick) clip-length)
                (difference (cylinder (* 1/2 arm-diameter)  (inc clip-length))))]
    (union (-> cub
               (difference (->> (cube thick (inc thick) (* 1.5  clip-length))
                                (rotate [0 (° 35) 0])
                                (translate [0 (* -1/2 (+ clip-length thick)) 0]))))
           (-> cyl
               (difference (->> (cube clip-length clip-length (inc clip-length))
                                (translate [0 (+ (- (/ arm-diameter 2) thick)
                                                 (* 0.9 (+ arm-diameter (* 1/2 thick)))) 0])))
               (->> (translate [0 (+ (* 1/2 (+ clip-length arm-diameter)) thick) 0]))))))

(render ($fn 100 (arm-clip)))
