(ns open-scad.models.wire-clip
  (:require [open-scad.core :refer :all]))


(def h  15)
(def epp 2)

(def d2 8)
(def d1 (+ d2 epp))
(def dx2)



(defgeometry wire-clip []
  (difference
    (difference (cylinder (/ d1 2) h)
                (cylinder (/ d2 2) (+ h 2)))
    (translate [(* 0.75 d1) 0 0]
               (cube (+ d1 1) (+ d1 1) (+ h 1)))))

(defgeometry model []
  (union (wire-clip)
         (->> (wire-clip)
              (scale [2 1 1])
              (rotate [0 0 (° 180)])
              (translate [(+ (- d1) (/ (- d1 d2) 2)) 0 0]))))











(render ($fn 100 (model)))
