(ns open-scad.models.bottles-tank
  (:require [open-scad.core                        :refer :all]
            [open-scad.libs.necks-caps             :refer :all]
            [open-scad.libs.universal-hose-adapter :refer :all]))

(def tube-inner-diameter 4)
(def tube-outer-diameter 6)
(def hose-height         15)
(def hose-wall-width     1)
(def hose-barb-width     0.8)

(def cap-diameter        38)
(def cap-height          11)

(defgeometry bottle-cap []
  (let [hole    (cylinder (/ tube-outer-diameter 2) 10 :center true)
        holesx2 (union (translate [(+ (/ cap-diameter 4)) 0 0] hole)
                       (translate [(- (/ cap-diameter 4)) 0 0] hole))
        hose    (->> (hose tube-inner-diameter tube-outer-diameter
                           hose-height hose-wall-width hose-barb-width
                           2 2 0.15)
                     (rotate [(° 180) 0 0])
                     (translate [0 0 (+ cap-height hose-height)]))
        hosex2  (union (translate [(+ (/ cap-diameter 4)) 0 0] hose)
                       (translate [(- (/ cap-diameter 4)) 0 0] hose))]
    (-> (->> (cap-38mm3start)
             (rotate [(° 180) 0 0])
             (translate [0 0 cap-height]))
        (difference (->> holesx2 (translate [0 0 cap-height])))
        (union hosex2))))

(def pump-hose-width 8.35)

(defgeometry pump-12v-hose-adapter []
  (hose-adapter
    ; cone1-min cone1-max cone1-height cone1-wall cone1-barb-width
    tube-inner-diameter tube-outer-diameter hose-height hose-wall-width hose-barb-width
    ; cone2-min cone2-max cone2-height cone2-wall cone2-barb-width
    (+ pump-hose-width 8) (- pump-hose-width 2) (* 2 hose-height) hose-wall-width hose-barb-width
    ; barb-flatness-ratio barb-spacing-ratio barb-skew-ratio
    2 2 0.5
    ; join-height check-guts
    3 0))

(render (part :bottle-cap-38mm (bottle-cap))
        (part :pump-12v-hose-adapter (pump-12v-hose-adapter)))
