(ns toxi.geom.utils
  (:use [toxi.geom.core :only [vec2d vec3d]]))

(defn swizzle
  "Selects a subset of 2d/3d vector components and/or re-organizes a vector
based on the given key. If the key contains a reference to z coordinates
and it's not present in the vector, a default value can be specified
(default 0).

For example
:x only returns the x coordinate.
:yx returns a 2d vector with the original y used as x and original x as y.
:xzy returns a 3d vector with y and z coordinates swapped."
  {:added "0.1"}
  ([v key] (swizzle v key 0))
  ([v key z]
    (case key
      :x (:x v)
      :y (:y v)
      :z (:z v z)
      :xy (vec2d (:x v) (:y v))
      :yx (vec2d (:y v) (:x v))
      :xz (vec2d (:x v) (:z v z))
      :zx (vec2d (:z v z) (:x v))
      :yz (vec2d (:y v) (:z v z))
      :zy (vec2d (:z v z) (:y v))
      :xyz (vec3d (:x v) (:y v) (:z v z))
      :xzy (vec3d (:x v) (:z v z) (:y v))
      :yxz (vec3d (:y v) (:x v) (:z v z))
      :yzx (vec3d (:y v) (:z v z) (:x v))
      :zxy (vec3d (:z v z) (:x v) (:y v))
      :zyx (vec3d (:z v z) (:y v) (:x v))
      )))

(defn xy=
  [a b]
  (and
    (= ^Double (:x a) ^Double (:x b))
    (= ^Double (:y a) ^Double (:y b))))

(defn xyz=
  [a b]
  (and
    (= ^Double (:x a) ^Double (:x b))
    (= ^Double (:y a) ^Double (:y b))
    (= ^Double (:z a) ^Double (:z b))))

(defn aset-vec2d
  [buf idx v]
  (aset-float buf idx (:x v))
  (aset-float buf (inc idx) (:y v)))

(defn aset-vec3d
  [buf idx v]
  (aset-float buf idx (:x v))
  (aset-float buf (inc idx) (:y v))
  (aset-float buf (+ 2 idx) (:z v)))
