(ns toxi.geom.types)

;; 2D related types

(defrecord Vec2D [^double x ^double y])
(defrecord Vec3D [^double x ^double y ^double z])
(defrecord Vec4D [^double x ^double y ^double z ^double w])

(defrecord Circle [^double x ^double y ^double radius])
(defrecord Ellipse [^double x ^double y ^Vec2D radius])
(defrecord Line2D [^Vec2D a ^Vec2D b])
(defrecord LineStrip2D [vertices])
(defrecord Triangle2D [^Vec2D a ^Vec2D b ^Vec2D c])
(defrecord Rect [^double x ^double y ^double width ^double height])
(defrecord Polygon2D [vertices])

;; 3D related types

(defrecord AABB [^double x ^double y ^double z ^Vec3D extent])
(defrecord Sphere [^double x ^double y ^double z ^double radius])


