(ns toxi.geom.mesh.core
  (:require
    [toxi.data.index :as index]
    [toxi.math.core :as math])
  (:use
    [toxi.geom.mesh.types])
  (:import
    [toxi.geom.mesh.types TriangleMesh3D Face3D]))

(defprotocol IMesh
  (add-faces [mesh a b c] [mesh a b c uvcoords] [mesh faces])
  (add-meshes [mesh coll])
  (compile-mesh [mesh] [mesh attribs] [mesh attribs accessors])
  (face-vertices [mesh f])
  (face-attribs [mesh f])
  (transform-mesh [mesh matrix])
  (vertex-at-point [mesh p])
)

(defprotocol IMesh3D
  (compute-face-normals [m])
  (compute-vertex-normals [m])
)

(defn triangle-mesh3d
  ([] (TriangleMesh3D.
        (index/make-index) ; vertex index
        (index/make-index) ; normal index
        [] ; vertex normal IDs
        {} ; attrib index
        []))) ; face list

(defn face3d
  ([^Integer a ^Integer b ^Integer c]
    (Face3D. (int a) (int b) (int c) (int -1) {}))
  ([^Integer a ^Integer b ^Integer c attribs]
    (Face3D. (int a) (int b) (int c) (int -1) attribs)))
