(ns toxi.geom.types)

;; 2D related types

(defrecord Vec2D [^double x ^double y])
(defrecord Vec3D [^double x ^double y ^double z])
(defrecord Vec4D [^double x ^double y ^double z ^double w])

(defrecord Circle [^double x ^double y ^double radius])
(defrecord Ellipse [^double x ^double y ^Vec2D radius])
(defrecord Line2D [^Vec2D a ^Vec2D b])
(defrecord Triangle2D [^Vec2D a ^Vec2D b ^Vec2D c])
(defrecord Rect [^double x ^double y ^double width ^double height])
(defrecord Polygon2D [vertices])

;; 3D related types

(defrecord Matrix4x4
  [^double m00 ^double m01 ^double m02 ^double m03
   ^double m10 ^double m11 ^double m12 ^double m13
   ^double m20 ^double m21 ^double m22 ^double m23
   ^double m30 ^double m31 ^double m32 ^double m33])

(defrecord Quaternion [^double x ^double y ^double z ^double w])

(defrecord AABB [^double x ^double y ^double z ^Vec3D extent])
(defrecord Sphere [^double x ^double y ^double z ^double radius])

(defrecord TriangleMesh3D [vertices normals vnormals attribs faces])

(defrecord Face3D [^int a ^int b ^int c ^int n attr])

