(ns toxi.geom.quaternion
  (:require
    [toxi.geom.utils :as utils]
    [toxi.math.core :as math])
  (:use
    [toxi.geom.protocols]
    [toxi.geom.core :only [vec3d matrix4x4 quaternion]]
    [toxi.geom.vec3d])
  (:import
    [toxi.geom.types Quaternion]))

(defn quat-from-axis-angle
  {:added "0.1"
   :java-id "toxi.geom.Quaternion.createFromAxisAngle"}
  [axis theta]
  (let [t2 (* 0.5 theta)]
    (quaternion (Math/cos t2) (normalize axis (Math/sin t2)))))

(defn alignment-quat
  {:added "0.1"
   :java-id "toxi.geom.Quaternion.getAlignmentQuat"}
  [dir forward]
  (let [target (normalize dir)
        axis (cross forward target)
        len (mag axis)
        theta (Math/atan2 len (dot forward target))]
    (quat-from-axis-angle axis theta)))

(defn ->matrix4x4
  {:added "0.1"
   :java-id "toxi.geom.Quaternion.toMatrix4x4"}
  [q]
  (let [{:keys [x y z w]} q
        x2 (+ x x) y2 (+ y y) z2 (+ z z)
        xx (* x x2) xy (* x y2) xz (* x z2)
        yy (* y y2) yz (* y z2) zz (* z z2)
        wx (* w x2) wy (* w y2) wz (* w z2)]
    (matrix4x4
      (- 1.0 (+ yy zz)) (- xy wz) (+ xz wy) 0.0
      (+ xy wz) (- 1.0 (+ xx zz)) (- yz wx) 0.0
      (- xz wy) (+ yz wx) (- 1.0 (+ xx yy)) 0.0
      0.0 0.0 0.0 1.0)))

