(ns toxi.geom.protocols)

(defprotocol IRotatable
  (rotate [e theta])
  (rotate-around-axis [e axis theta])
  (rotate-x [e theta])
  (rotate-y [e theta])
  (rotate-z [e theta])
)

(defprotocol IScalable
  (scale [e v] [e x y] [e x y z])
  (scale-n [e s])
)

(defprotocol ITranslatable
  (translate [e v] [e x y] [e x y z])
)

(defprotocol ITransformable
  (transform [c matrix])
)

(defprotocol IInvertible
  (invert [e])
)

(defprotocol IInterpolatable
  (interpolate [a b t] [a b t f])
)

(defprotocol IClassifiable
  (classify-point [c p])
)

(defprotocol IVec
  (absv [v])
  (add [a b] [a b c] [a b c & more])
  (angle-between [a b])
  (angle-between-norm [a b])
  (cross [a b])
  (deltav= [a b] [a b delta])
  (distance [a b])
  (distance-squared [a b])
  (dot [a b])
  (limit [v len])
  (mag [v])
  (mag-squared [v])
  (maxv [a b] [a b c])
  (minv [a b] [a b c])
  (normalize [v] [v len])
  (reflect [v r])
  (sub [a b] [a b & more])
  (->cartesian [v])
  (->vec [v])
  (zerov? [v])
)

(defprotocol IVec2D
  (bisect [a b])
  (heading [v])
  (perpendicular [v])
  (slope [v])
  (->3dxy [v])
  (->3dxz [v])
  (->3dyz [v])
  (->polar [v])
)

(defprotocol IVec3D
  (->2dxy [v])
  (->2dxz [v])
  (->2dyz [v])
)

(defprotocol IShape
  (bounds [s])
  (contains-point? [s p])
  (random-point [s])
  (centroid [s])
)

(defprotocol IShape2D
  (area [s])
  (bounding-circle [s])
  (circumference [s])
  (edges [s] [s res])
  (->polygon2d [s] [s res])
)

(defprotocol IShape3D
  (bounding-sphere [s])
  (->mesh [s] [s res])
)

(defprotocol ILine
  (intersect-lines [a b])
  (line-closest-point-to [l p])
  (line-direction [l])
  (line-distance-to-point [l p])
  (line-has-endpoint? [l p])
  (line-length [l])
  (line-length-squared [l])
  (line-normal [l])
  (offset-and-grow-by [line offset] [line offset scale] [line offset scale refp])
  (point-on-line [l t])
  (split-line [line len] [line len coll] [line len coll addfirst?])
)

(defprotocol ILine2D
  (theta [l])
)

(defprotocol ITriangle
  (adjust-size [t offset] [t offa offb offc])
  (clockwise? [t])
  (from-barycentric [t b])
  (intersect-triangles [a b])
  (triangle-closest-point-to [t p])
)

(defprotocol IPolygon2D
  (add-vertex [poly v])
  (contains-polygon? [a b])
  (flip [poly])
  (intersect-polygons [a b])
  (vertex-count [poly])
)

(defprotocol IRect
  (bottom[r])
  (bottom-left[r])
  (bottom-right[r])
  (dimensions[r])
  (left[r])
  (right[r])
  (top[r])
  (top-left[r])
  (top-right[r])
)

(defprotocol ICircle
  (intersect-circles [a b])
  (tangent-points [c p])
)

(defprotocol IEllipse
  (foci [e])
)

(defprotocol IMatrix
  (matrix-multiply [m m2])
  (matrix-transpose [m])
)

(defprotocol IMatrix4x4
  (transform-point [m v])
  (transform-normal [m v])  
)

(defprotocol IAABB
  (bounds-min [b])
  (bounds-max [b])
)

(defprotocol IMesh
  (add-faces [mesh a b c] [mesh a b c uvcoords] [mesh faces])
  (add-mesh [src target])
  (compile-mesh [mesh] [mesh attribs] [mesh attribs accessors])
  (face-vertices [mesh f])
  (face-attribs [mesh f])
  (transform-mesh [mesh matrix])
  (vertex-at-point [mesh p])
)

(defprotocol IMesh3D
  (compute-face-normals [m])
  (compute-vertex-normals [m])
)
