(ns toxi.geom.mesh.objexport)

(defn ->obj
  [mesh & attribs]
  (let[serializers {
         :vertices {
            :face-ids (fn[f] [(inc (:a f)) (inc (:b f)) (inc (:c f))])
         }
         :fnormals {
            :source (fn[mesh] (:items (:normals mesh)))
            :item (fn[obj n] (str obj "vn " (:x n) " " (:y n) " " (:z n) "\n"))
            :face-ids (fn[f] (let[n (inc (:n f))] [n n n]))
         }
         :vnormals {
            :source (fn[mesh] (:items (:normals mesh)))
            :item (fn[obj n]
	                 (str obj "vn " (:x n) " " (:y n) " " (:z n) "\n"))
            :face-ids (fn[f]
                       (let[vn (:vnormals mesh)]
                          [(inc (get vn (:a f)))
                           (inc (get vn (:b f)))
                           (inc (get vn (:c f)))]))
         }
         :uv {
            :source (fn[mesh] (:items (get (:attribs mesh) :uv)))
            :item (fn[obj uv] (str obj "vt " (:x uv) " " (:y uv) "\n"))
            :face-ids (fn[f] (vec (map inc (:uv (:attr f)))))
         }
       }
       use-fnormals (some #{:fnormals} attribs) 
       use-vnormals (some #{:vnormals} attribs)
       use-uv (some #{:uv} attribs)
       face-defs (cond
                  (and use-uv (not (or use-fnormals use-vnormals)))
                    [:vertices :uv]
                  (and use-uv use-fnormals)
                    [:vertices :uv :fnormals]
                  (and use-uv use-vnormals)
                    [:vertices :uv :vnormals]
                  use-fnormals
                    [:vertices nil :fnormals]
                  use-vnormals
                    [:vertices nil :vnormals]
                  (not (or use-fnormals use-vnormals use-uv))
                    [:vertices])      
       obj (reduce
             (fn[obj v]
               (str obj "v " (:x v) " " (:y v) " " (:z v) "\n"))
             "" (:items (:vertices mesh)))
       obj (reduce
             (fn[obj attr]
               (let[s (get serializers attr)]
                 (reduce (:item s) obj ((:source s) mesh))))
             obj attribs)
       obj (reduce
             (fn[obj f]
               (let [ids (reduce
                           (fn[acc att]
                             (if (nil? att)
                               (conj acc [nil nil nil])
                               (conj acc ((:face-ids (get serializers att)) f))))
                           []
                           face-defs)
                     ids (case (count ids)
                           1 (first ids)
                           2 (vec (map #(apply str (interpose "/" %))
                                  (partition 2 (interleave (get ids 0) (get ids 1)))))
                           3 (vec (map #(apply str (interpose "/" %))
                                  (partition 3 (interleave (get ids 0) (get ids 1) (get ids 2))))))]
                 (str obj "f " (get ids 0) " " (get ids 1) " " (get ids 2) "\n")))                 
                 (str obj "g\n")
             (:faces mesh))]
    obj))
