(ns toxi.color.core
  (:require
    [toxi.math.core :as math]))

(defrecord TColor [
   ^double r ^double g ^double b ^double a
   ^double h ^double s ^double v
   ^double c ^double y ^double m ^double k])

(defn tcolor
  ([] (tcolor :gray [0]))
  ([gray]
    (cond
      (= gray :random) (tcolor :random [])
      (number? gray) (tcolor (tcolor :gray [gray]))))
  ([mode [a b c d e]]
    (case mode
      :rgb (TColor.
             a b c 1.0
             0 0 0
             0 0 0 0)
      :rgba (TColor.
              a b c d
              0 0 0
              0 0 0 0)
      :hsv (TColor.
             0 0 0 1.0
             a b c
             0 0 0 0)
      :hsva (TColor.
              0 0 0 d
              a b c
              0 0 0 0)
      :cmyk (TColor.
              0 0 0 1.0
              0 0 0
              a b c d)
      :cmyka (TColor.
               0 0 0 e
               0 0 0
               a b c d)
      :gray (TColor.
              a a a 1.0
              0 0 0
              0 0 0 0)
      :graya (TColor.
                a a a b
                0 0 0
                0 0 0 0)
      :random (TColor.
                (math/random) (math/random) (math/random) 1.0
                0 0 0
                0 0 0 0)
      :randoma (TColor.
                  (math/random) (math/random) (math/random) a
                  0 0 0
                  0 0 0 0)
      )))

